/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    private final List<Object> myListeners;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;

    RegistryValue(@NotNull Registry registry, @NotNull String key) {
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue", "<init>"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRegistry = registry;
        this.myKey = key;
    }

    @NotNull
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue", "asString"));
        }
        return string;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            try {
                this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = RegistryValue.getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myIntCachedValue = Integer.valueOf(bundleValue);
            }
        }
        return this.myIntCachedValue;
    }

    public double asDouble() {
        if (this.myDoubleCachedValue == null) {
            try {
                this.myDoubleCachedValue = Double.valueOf(this.get(this.myKey, "0.0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = RegistryValue.getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myDoubleCachedValue = Double.valueOf(bundleValue);
            }
        }
        return this.myDoubleCachedValue;
    }

    private String get(@NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue", "get"));
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, isValue);
                if (this.isBoolean()) {
                    this.myStringCachedValue = Boolean.valueOf(this.myStringCachedValue).toString();
                }
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, isValue);
    }

    private String _get(@NotNull String key, String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue", "_get"));
        }
        String userValue = this.myRegistry.getUserProperties().get(key);
        if (userValue != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        String bundleValue = RegistryValue.getBundleValue(key, mustExistInBundle);
        if (bundleValue != null) {
            return bundleValue;
        }
        return defaultValue;
    }

    private static String getBundleValue(@NotNull String key, boolean mustExist) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue", "getBundleValue"));
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    public boolean isBoolean() {
        return "true".equals(this.asString()) || "false".equals(this.asString());
    }
}

