/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformTargets;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.transform.DefaultArtifactTransformTargets;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultAttributeContainer;
import org.gradle.internal.reflect.DirectInstantiator;

public class ArtifactTransformRegistrations {
    private final List<ArtifactTransformRegistration> transforms = Lists.newArrayList();

    public void registerTransform(Class<? extends ArtifactTransform> type, Action<? super ArtifactTransform> config) {
        ArtifactTransform artifactTransform = (ArtifactTransform)DirectInstantiator.INSTANCE.newInstance(type, new Object[0]);
        DefaultAttributeContainer from = new DefaultAttributeContainer();
        DefaultArtifactTransformTargets registry = new DefaultArtifactTransformTargets();
        artifactTransform.configure((AttributeContainer)from, (ArtifactTransformTargets)registry);
        for (AttributeContainerInternal to : registry.getNewTargets()) {
            ArtifactTransformRegistration registration = new ArtifactTransformRegistration((AttributeContainer)from.asImmutable(), (AttributeContainer)to.asImmutable(), type, config);
            this.transforms.add(registration);
        }
    }

    public Iterable<ArtifactTransformRegistration> getTransforms() {
        return this.transforms;
    }

    public final class ArtifactTransformRegistration {
        public final AttributeContainer from;
        public final AttributeContainer to;
        public final Class<? extends ArtifactTransform> type;
        public final Action<? super ArtifactTransform> config;

        ArtifactTransformRegistration(AttributeContainer from, AttributeContainer to, Class<? extends ArtifactTransform> type, Action<? super ArtifactTransform> config) {
            this.from = from;
            this.to = to;
            this.type = type;
            this.config = config;
        }
    }
}

