/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.serialize.AbstractCollectionSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetSerializer<T>
extends AbstractCollectionSerializer<T>
implements Serializer<Set<T>> {
    private final boolean linkedHashSet;

    public SetSerializer(Serializer<T> entrySerializer) {
        this(entrySerializer, true);
    }

    public SetSerializer(Serializer<T> entrySerializer, boolean linkedHashSet) {
        super(entrySerializer);
        this.linkedHashSet = linkedHashSet;
    }

    @Override
    public Set<T> read(Decoder decoder) throws Exception {
        HashSet values = this.linkedHashSet ? new LinkedHashSet() : new HashSet();
        this.readValues(decoder, values);
        return values;
    }

    @Override
    public void write(Encoder encoder, Set<T> value) throws Exception {
        this.writeValues(encoder, value);
    }
}

