/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadHashValueNode
extends FormatNode {
    private final Object key;
    @Node.Child
    private CallDispatchHeadNode fetchNode;
    private final ConditionProfile oneHashProfile = ConditionProfile.createBinaryProfile();

    public ReadHashValueNode(Object key) {
        this.key = key;
    }

    @Specialization
    public Object read(VirtualFrame frame, Object[] source) {
        if (this.oneHashProfile.profile(source.length != 1 || !RubyGuards.isRubyHash(source[0]))) {
            throw new RaiseException(this.getContext().getCoreExceptions().argumentErrorOneHashRequired(this));
        }
        DynamicObject hash = (DynamicObject)source[0];
        if (this.fetchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fetchNode = this.insert(DispatchHeadNodeFactory.createMethodCall(true));
        }
        return this.fetchNode.call(frame, hash, "fetch", this.key);
    }
}

