/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Specialization;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;

@CoreClass(value="Truffle::GC")
public abstract class TruffleGCNodes {

    @CoreMethod(names={"time"}, onSingleton=true)
    public static abstract class TimeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long time() {
            if (TruffleOptions.AOT) {
                throw new UnsupportedOperationException("Memory manager is not available with AOT.");
            }
            return TimeNode.getCollectionTime();
        }

        public static long getCollectionTime() {
            long time = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                time += bean.getCollectionTime();
            }
            return time;
        }
    }

    @CoreMethod(names={"count"}, onSingleton=true)
    public static abstract class CountNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int count() {
            if (TruffleOptions.AOT) {
                throw new UnsupportedOperationException("Memory manager is not available with AOT.");
            }
            return CountNode.getCollectionCount();
        }

        public static int getCollectionCount() {
            int count = 0;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                count = (int)((long)count + bean.getCollectionCount());
            }
            return count;
        }
    }
}

