/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.array.ArrayGeneralizeNodeGen;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class ArrayGeneralizeNode
extends RubyNode {
    public static ArrayGeneralizeNode create() {
        return ArrayGeneralizeNodeGen.create(null, null);
    }

    public abstract Object[] executeGeneralize(DynamicObject var1, int var2);

    @Specialization(guards={"strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public Object[] generalize(DynamicObject array, int requiredCapacity, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="createCountingProfile()") ConditionProfile extendProfile) {
        assert (!ArrayGuards.isObjectArray(array));
        ArrayMirror mirror = strategy.newMirror(array);
        int capacity = extendProfile.profile(mirror.getLength() < requiredCapacity) ? ArrayUtils.capacity(this.getContext(), mirror.getLength(), requiredCapacity) : mirror.getLength();
        Object[] store = mirror.getBoxedCopy(capacity);
        strategy.setStore(array, store);
        return store;
    }
}

