/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.basicobject;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.core.basicobject.BasicObjectLayout;
import org.jruby.truffle.language.RubyObjectType;

@GeneratedBy(value=BasicObjectLayout.class)
public class BasicObjectLayoutImpl
implements BasicObjectLayout {
    public static final BasicObjectLayout INSTANCE = new BasicObjectLayoutImpl();
    protected static final Layout LAYOUT = Layout.newLayout().addAllowedImplicitCast(Layout.ImplicitCast.IntToLong).build();
    protected static final Shape.Allocator BASIC_OBJECT_ALLOCATOR = LAYOUT.createAllocator();

    protected BasicObjectLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createBasicObjectShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new BasicObjectType(logicalClass, metaClass)).createFactory();
    }

    @Override
    public DynamicObject createBasicObject(DynamicObjectFactory factory) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (BasicObjectLayoutImpl.createsBasicObject(factory));
        return factory.newInstance(new Object[0]);
    }

    @Override
    public boolean isBasicObject(Object object) {
        return object instanceof DynamicObject && BasicObjectLayoutImpl.isBasicObject((DynamicObject)object);
    }

    private static boolean isBasicObject(DynamicObject object) {
        return BasicObjectLayoutImpl.isBasicObject(object.getShape().getObjectType());
    }

    private static boolean isBasicObject(ObjectType objectType) {
        return objectType instanceof BasicObjectType;
    }

    private static boolean createsBasicObject(DynamicObjectFactory factory) {
        return BasicObjectLayoutImpl.isBasicObject(factory.getShape().getObjectType());
    }

    @Override
    public DynamicObject getLogicalClass(ObjectType objectType) {
        assert (BasicObjectLayoutImpl.isBasicObject(objectType));
        return ((BasicObjectType)objectType).getLogicalClass();
    }

    @Override
    public DynamicObject getLogicalClass(DynamicObject object) {
        assert (BasicObjectLayoutImpl.isBasicObject(object));
        return BasicObjectLayoutImpl.getObjectType(object).getLogicalClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObjectFactory setLogicalClass(DynamicObjectFactory factory, DynamicObject value) {
        assert (BasicObjectLayoutImpl.createsBasicObject(factory));
        Shape shape = factory.getShape();
        return shape.changeType(((BasicObjectType)shape.getObjectType()).setLogicalClass(value)).createFactory();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setLogicalClass(DynamicObject object, DynamicObject value) {
        assert (BasicObjectLayoutImpl.isBasicObject(object));
        Shape shape = object.getShape();
        object.setShapeAndGrow(shape, shape.changeType(BasicObjectLayoutImpl.getObjectType(object).setLogicalClass(value)));
    }

    @Override
    public DynamicObject getMetaClass(ObjectType objectType) {
        assert (BasicObjectLayoutImpl.isBasicObject(objectType));
        return ((BasicObjectType)objectType).getMetaClass();
    }

    @Override
    public DynamicObject getMetaClass(DynamicObject object) {
        assert (BasicObjectLayoutImpl.isBasicObject(object));
        return BasicObjectLayoutImpl.getObjectType(object).getMetaClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObjectFactory setMetaClass(DynamicObjectFactory factory, DynamicObject value) {
        assert (BasicObjectLayoutImpl.createsBasicObject(factory));
        Shape shape = factory.getShape();
        return shape.changeType(((BasicObjectType)shape.getObjectType()).setMetaClass(value)).createFactory();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setMetaClass(DynamicObject object, DynamicObject value) {
        assert (BasicObjectLayoutImpl.isBasicObject(object));
        Shape shape = object.getShape();
        object.setShapeAndGrow(shape, shape.changeType(BasicObjectLayoutImpl.getObjectType(object).setMetaClass(value)));
    }

    private static BasicObjectType getObjectType(DynamicObject object) {
        assert (BasicObjectLayoutImpl.isBasicObject(object));
        return (BasicObjectType)object.getShape().getObjectType();
    }

    public static class BasicObjectType
    extends RubyObjectType {
        protected final DynamicObject logicalClass;
        protected final DynamicObject metaClass;

        public BasicObjectType(DynamicObject logicalClass, DynamicObject metaClass) {
            this.logicalClass = logicalClass;
            this.metaClass = metaClass;
        }

        public DynamicObject getLogicalClass() {
            return this.logicalClass;
        }

        public BasicObjectType setLogicalClass(DynamicObject logicalClass) {
            return new BasicObjectType(logicalClass, this.metaClass);
        }

        public DynamicObject getMetaClass() {
            return this.metaClass;
        }

        public BasicObjectType setMetaClass(DynamicObject metaClass) {
            return new BasicObjectType(this.logicalClass, metaClass);
        }
    }
}

