/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.stdlib.readline.ReadlineNodes;

@GeneratedBy(value=ReadlineNodes.class)
public final class ReadlineNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(BasicWordBreakCharactersNodeFactory.getInstance(), SetBasicWordBreakCharactersNodeFactory.getInstance(), GetScreenSizeNodeFactory.getInstance(), ReadlineNodeFactory.getInstance(), PointNodeFactory.getInstance(), InsertTextNodeFactory.getInstance(), DeleteTextNodeFactory.getInstance(), LineBufferNodeFactory.getInstance(), RefreshLineNodeFactory.getInstance());
    }

    @GeneratedBy(value=ReadlineNodes.RefreshLineNode.class)
    public static final class RefreshLineNodeFactory
    implements NodeFactory<ReadlineNodes.RefreshLineNode> {
        private static RefreshLineNodeFactory refreshLineNodeFactoryInstance;

        private RefreshLineNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.RefreshLineNode> getNodeClass() {
            return ReadlineNodes.RefreshLineNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineNodes.RefreshLineNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RefreshLineNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.RefreshLineNode> getInstance() {
            if (refreshLineNodeFactoryInstance == null) {
                refreshLineNodeFactoryInstance = new RefreshLineNodeFactory();
            }
            return refreshLineNodeFactoryInstance;
        }

        public static ReadlineNodes.RefreshLineNode create(RubyNode[] arguments) {
            return new RefreshLineNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineNodes.RefreshLineNode.class)
        public static final class RefreshLineNodeGen
        extends ReadlineNodes.RefreshLineNode {
            private RefreshLineNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.refreshLine();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.LineBufferNode.class)
    public static final class LineBufferNodeFactory
    implements NodeFactory<ReadlineNodes.LineBufferNode> {
        private static LineBufferNodeFactory lineBufferNodeFactoryInstance;

        private LineBufferNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.LineBufferNode> getNodeClass() {
            return ReadlineNodes.LineBufferNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineNodes.LineBufferNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LineBufferNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.LineBufferNode> getInstance() {
            if (lineBufferNodeFactoryInstance == null) {
                lineBufferNodeFactoryInstance = new LineBufferNodeFactory();
            }
            return lineBufferNodeFactoryInstance;
        }

        public static ReadlineNodes.LineBufferNode create(RubyNode[] arguments) {
            return new LineBufferNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineNodes.LineBufferNode.class)
        public static final class LineBufferNodeGen
        extends ReadlineNodes.LineBufferNode {
            private LineBufferNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.lineBuffer();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.DeleteTextNode.class)
    public static final class DeleteTextNodeFactory
    implements NodeFactory<ReadlineNodes.DeleteTextNode> {
        private static DeleteTextNodeFactory deleteTextNodeFactoryInstance;

        private DeleteTextNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.DeleteTextNode> getNodeClass() {
            return ReadlineNodes.DeleteTextNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineNodes.DeleteTextNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DeleteTextNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.DeleteTextNode> getInstance() {
            if (deleteTextNodeFactoryInstance == null) {
                deleteTextNodeFactoryInstance = new DeleteTextNodeFactory();
            }
            return deleteTextNodeFactoryInstance;
        }

        public static ReadlineNodes.DeleteTextNode create(RubyNode[] arguments) {
            return new DeleteTextNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineNodes.DeleteTextNode.class)
        public static final class DeleteTextNodeGen
        extends ReadlineNodes.DeleteTextNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DeleteTextNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.deleteText(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.InsertTextNode.class)
    public static final class InsertTextNodeFactory
    implements NodeFactory<ReadlineNodes.InsertTextNode> {
        private static InsertTextNodeFactory insertTextNodeFactoryInstance;

        private InsertTextNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.InsertTextNode> getNodeClass() {
            return ReadlineNodes.InsertTextNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        @Override
        public ReadlineNodes.InsertTextNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return InsertTextNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.InsertTextNode> getInstance() {
            if (insertTextNodeFactoryInstance == null) {
                insertTextNodeFactoryInstance = new InsertTextNodeFactory();
            }
            return insertTextNodeFactoryInstance;
        }

        public static ReadlineNodes.InsertTextNode create(RubyNode self, RubyNode text) {
            return new InsertTextNodeGen(self, text);
        }

        @GeneratedBy(value=ReadlineNodes.InsertTextNode.class)
        public static final class InsertTextNodeGen
        extends ReadlineNodes.InsertTextNode {
            @Node.Child
            private RubyNode self_;
            @Node.Child
            private RubyNode text_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private InsertTextNodeGen(RubyNode self, RubyNode text) {
                this.self_ = self;
                this.text_ = this.coerceTextToString(text);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String textValue_;
                DynamicObject selfValue_;
                try {
                    selfValue_ = this.self_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object textValue = this.text_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), textValue);
                }
                try {
                    textValue_ = InsertTextNodeGen.expectString(this.text_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(selfValue_, ex.getResult());
                }
                return this.insertText(selfValue_, textValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object selfValue, Object textValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.self_, this.text_}, selfValue, textValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.PointNode.class)
    public static final class PointNodeFactory
    implements NodeFactory<ReadlineNodes.PointNode> {
        private static PointNodeFactory pointNodeFactoryInstance;

        private PointNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.PointNode> getNodeClass() {
            return ReadlineNodes.PointNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineNodes.PointNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PointNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.PointNode> getInstance() {
            if (pointNodeFactoryInstance == null) {
                pointNodeFactoryInstance = new PointNodeFactory();
            }
            return pointNodeFactoryInstance;
        }

        public static ReadlineNodes.PointNode create(RubyNode[] arguments) {
            return new PointNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineNodes.PointNode.class)
        public static final class PointNodeGen
        extends ReadlineNodes.PointNode {
            private PointNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.point();
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.ReadlineNode.class)
    public static final class ReadlineNodeFactory
    implements NodeFactory<ReadlineNodes.ReadlineNode> {
        private static ReadlineNodeFactory readlineNodeFactoryInstance;

        private ReadlineNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.ReadlineNode> getNodeClass() {
            return ReadlineNodes.ReadlineNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        @Override
        public ReadlineNodes.ReadlineNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ReadlineNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.ReadlineNode> getInstance() {
            if (readlineNodeFactoryInstance == null) {
                readlineNodeFactoryInstance = new ReadlineNodeFactory();
            }
            return readlineNodeFactoryInstance;
        }

        public static ReadlineNodes.ReadlineNode create(RubyNode prompt, RubyNode addToHistory) {
            return new ReadlineNodeGen(prompt, addToHistory);
        }

        @GeneratedBy(value=ReadlineNodes.ReadlineNode.class)
        public static final class ReadlineNodeGen
        extends ReadlineNodes.ReadlineNode {
            @Node.Child
            private RubyNode prompt_;
            @Node.Child
            private RubyNode addToHistory_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ReadlineNodeGen(RubyNode prompt, RubyNode addToHistory) {
                this.prompt_ = this.coercePromptToJavaString(prompt);
                this.addToHistory_ = this.coerceToBoolean(addToHistory);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean addToHistoryValue_;
                String promptValue_;
                try {
                    promptValue_ = ReadlineNodeGen.expectString(this.prompt_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object addToHistoryValue = this.addToHistory_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), addToHistoryValue);
                }
                try {
                    addToHistoryValue_ = this.addToHistory_.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(promptValue_, ex.getResult());
                }
                return this.readline(promptValue_, addToHistoryValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object promptValue, Object addToHistoryValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.prompt_, this.addToHistory_}, promptValue, addToHistoryValue);
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.GetScreenSizeNode.class)
    public static final class GetScreenSizeNodeFactory
    implements NodeFactory<ReadlineNodes.GetScreenSizeNode> {
        private static GetScreenSizeNodeFactory getScreenSizeNodeFactoryInstance;

        private GetScreenSizeNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.GetScreenSizeNode> getNodeClass() {
            return ReadlineNodes.GetScreenSizeNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineNodes.GetScreenSizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetScreenSizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.GetScreenSizeNode> getInstance() {
            if (getScreenSizeNodeFactoryInstance == null) {
                getScreenSizeNodeFactoryInstance = new GetScreenSizeNodeFactory();
            }
            return getScreenSizeNodeFactoryInstance;
        }

        public static ReadlineNodes.GetScreenSizeNode create(RubyNode[] arguments) {
            return new GetScreenSizeNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineNodes.GetScreenSizeNode.class)
        public static final class GetScreenSizeNodeGen
        extends ReadlineNodes.GetScreenSizeNode {
            private GetScreenSizeNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.getScreenSize();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.SetBasicWordBreakCharactersNode.class)
    public static final class SetBasicWordBreakCharactersNodeFactory
    implements NodeFactory<ReadlineNodes.SetBasicWordBreakCharactersNode> {
        private static SetBasicWordBreakCharactersNodeFactory setBasicWordBreakCharactersNodeFactoryInstance;

        private SetBasicWordBreakCharactersNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.SetBasicWordBreakCharactersNode> getNodeClass() {
            return ReadlineNodes.SetBasicWordBreakCharactersNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class));
        }

        @Override
        public ReadlineNodes.SetBasicWordBreakCharactersNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return SetBasicWordBreakCharactersNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.SetBasicWordBreakCharactersNode> getInstance() {
            if (setBasicWordBreakCharactersNodeFactoryInstance == null) {
                setBasicWordBreakCharactersNodeFactoryInstance = new SetBasicWordBreakCharactersNodeFactory();
            }
            return setBasicWordBreakCharactersNodeFactoryInstance;
        }

        public static ReadlineNodes.SetBasicWordBreakCharactersNode create(RubyNode characters) {
            return new SetBasicWordBreakCharactersNodeGen(characters);
        }

        @GeneratedBy(value=ReadlineNodes.SetBasicWordBreakCharactersNode.class)
        public static final class SetBasicWordBreakCharactersNodeGen
        extends ReadlineNodes.SetBasicWordBreakCharactersNode {
            @Node.Child
            private RubyNode characters_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SetBasicWordBreakCharactersNodeGen(RubyNode characters) {
                this.characters_ = this.coerceCharactersToString(characters);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject charactersValue_;
                try {
                    charactersValue_ = this.characters_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.setBasicWordBreakCharacters(charactersValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object charactersValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.characters_}, charactersValue);
            }
        }
    }

    @GeneratedBy(value=ReadlineNodes.BasicWordBreakCharactersNode.class)
    public static final class BasicWordBreakCharactersNodeFactory
    implements NodeFactory<ReadlineNodes.BasicWordBreakCharactersNode> {
        private static BasicWordBreakCharactersNodeFactory basicWordBreakCharactersNodeFactoryInstance;

        private BasicWordBreakCharactersNodeFactory() {
        }

        @Override
        public Class<ReadlineNodes.BasicWordBreakCharactersNode> getNodeClass() {
            return ReadlineNodes.BasicWordBreakCharactersNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineNodes.BasicWordBreakCharactersNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BasicWordBreakCharactersNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineNodes.BasicWordBreakCharactersNode> getInstance() {
            if (basicWordBreakCharactersNodeFactoryInstance == null) {
                basicWordBreakCharactersNodeFactoryInstance = new BasicWordBreakCharactersNodeFactory();
            }
            return basicWordBreakCharactersNodeFactoryInstance;
        }

        public static ReadlineNodes.BasicWordBreakCharactersNode create(RubyNode[] arguments) {
            return new BasicWordBreakCharactersNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineNodes.BasicWordBreakCharactersNode.class)
        public static final class BasicWordBreakCharactersNodeGen
        extends ReadlineNodes.BasicWordBreakCharactersNode {
            private BasicWordBreakCharactersNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.basicWordBreakCharacters();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }
}

