/**
 * Copyright 2015 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
'use strict';

// Default configuration
module.exports = {
  trace: {
    // Log levels: 0-disabled,1-error,2-warn,3-info,4-debug
    logLevel: 1,

    enabled: true,

    // If true, information about query parameters and results will be
    // attached to spans representating database operations.
    enhancedDatabaseReporting: true,

    // The maximum result size in characters to report on database spans if
    // `enhancedDatabaseReporting` is enabled.
    databaseResultReportingSize: 127,

    // Valid entries are:
    // 'express', 'hapi', 'http', 'restify'
    excludedHooks: [],

    // @type {number} max number of frames to include on traces (0 disables)
    stackTraceLimit: 10,

    // Not used
    flushDelaySeconds: 30,
    
    // This filter will exclude trace before any rate is applied
    // For each entry key, there is an array of value that might matching
    // if any of these value are matched, trace are ignored
    // Any value can be string or regex
    ignoreFilter: {
      'url': [],
      'method': []
    },

    // An upper bound on the number of traces to gather each second. If set to 0,
    // sampling is disabled and all traces are recorded. Sampling rates greater
    // than 1000 are not supported and will result in at most 1000 samples per
    // second. Some Google Cloud environments may further limit this rate.
    samplingRate: 0,

    // Not used
    bufferSize: 5,

    // Specifies the behavior of the trace agent in the case of an uncaught exception.
    // Possible values are:
    //   `ignore`: Take no action. Note that the process may termiante before all the
    //            traces currently buffered have been flushed to the network.
    //   `flush`: Handle the uncaught exception and attempt to publish the traces to
    //            the API. Note that if you have other uncaught exception handlers in your
    //            application, they may chose to terminate the process before the
    //            buffer has been flushed to the network. Also note that if you have no
    //            other terminating uncaught exception handlers in your application, the
    //            error will get swallowed and the application will keep on running. You
    //            should use this option if you have other uncaught exception handlers
    //            that you want to be responsible for terminating the application.
    //   `flushAndExit`: Handle the uncaught exception, make a best effort attempt to
    //            publish the traces to the API, and then terminate the application after
    //            a delay. Note that presence of other uncaught exception handlers may
    //            chose to terminate the application before the buffer has been flushed to
    //            the network.
    onUncaughtException: 'ignore',

    // EXPERIMENTAL:
    // Allows to ignore the requests X-Cloud-Trace-Context -header if set. Setting this
    // to true will cause traces generated by this module to appear separately from other
    // distributed work done by other services on behalf of the same income request. Setting
    // this will also cause sampling decisions made by other distributed components to be
    // ignored. This is useful for aggregating traces generated by different cloud platform
    // projects.
    ignoreContextHeader: false
  }
};
