/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.attributes;

import com.google.common.io.Files;
import java.io.File;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.attributes.DefaultAttributeContainer;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultArtifactAttributes {
    public static AttributeContainer forIvyArtifactName(IvyArtifactName ivyArtifactName) {
        return DefaultArtifactAttributes.createAttributes(ivyArtifactName.getType(), ivyArtifactName.getExtension(), ivyArtifactName.getClassifier());
    }

    public static AttributeContainer forFile(File file) {
        String extension = Files.getFileExtension((String)file.getName());
        return DefaultArtifactAttributes.createAttributes(extension, extension, "");
    }

    private static AttributeContainer createAttributes(String type, String extension, String classifier) {
        DefaultAttributeContainer attributes = new DefaultAttributeContainer();
        attributes.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)(type == null ? "" : type));
        attributes.attribute(ArtifactAttributes.ARTIFACT_EXTENSION, (Object)(extension == null ? "" : extension));
        attributes.attribute(ArtifactAttributes.ARTIFACT_CLASSIFIER, (Object)(classifier == null ? "" : classifier));
        return attributes.asImmutable();
    }
}

