/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactBackedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DefaultAttributeContainer;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.VariantMetadata;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactResolveResult;

public class DefaultArtifactSet
implements ArtifactSet {
    private final ModuleVersionIdentifier moduleVersionIdentifier;
    private final ModuleSource moduleSource;
    private final ModuleExclusion exclusions;
    private final Set<? extends VariantMetadata> variants;
    private final ArtifactResolver artifactResolver;
    private final Map<ComponentArtifactIdentifier, ResolvedArtifact> allResolvedArtifacts;
    private final long id;

    public DefaultArtifactSet(ModuleVersionIdentifier ownerId, ModuleSource moduleSource, ModuleExclusion exclusions, Set<? extends VariantMetadata> variants, ArtifactResolver artifactResolver, Map<ComponentArtifactIdentifier, ResolvedArtifact> allResolvedArtifacts, long id) {
        this.moduleVersionIdentifier = ownerId;
        this.moduleSource = moduleSource;
        this.exclusions = exclusions;
        this.variants = variants;
        this.artifactResolver = artifactResolver;
        this.allResolvedArtifacts = allResolvedArtifacts;
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Set<? extends ResolvedVariant> getVariants() {
        return this.snapshot().getVariants();
    }

    @Override
    public ArtifactSet snapshot() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (VariantMetadata variantMetadata : this.variants) {
            Set<? extends ComponentArtifactMetadata> artifacts = variantMetadata.getArtifacts();
            LinkedHashSet<ResolvedArtifact> resolvedArtifacts = new LinkedHashSet<ResolvedArtifact>(artifacts.size());
            AttributeContainerInternal attributes = variantMetadata.getAttributes();
            if (artifacts.size() == 1 && !attributes.contains(ArtifactAttributes.ARTIFACT_FORMAT)) {
                DefaultAttributeContainer implicitAttributes = new DefaultAttributeContainer(attributes);
                implicitAttributes.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)artifacts.iterator().next().getName().getType());
                attributes = implicitAttributes.asImmutable();
            }
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                IvyArtifactName artifactName = componentArtifactMetadata.getName();
                if (this.exclusions.excludeArtifact(this.moduleVersionIdentifier.getModule(), artifactName)) continue;
                ResolvedArtifact resolvedArtifact = this.allResolvedArtifacts.get(componentArtifactMetadata.getId());
                if (resolvedArtifact == null) {
                    LazyArtifactSource artifactSource = new LazyArtifactSource(componentArtifactMetadata, this.moduleSource, this.artifactResolver);
                    resolvedArtifact = new DefaultResolvedArtifact(this.moduleVersionIdentifier, artifactName, componentArtifactMetadata.getId(), componentArtifactMetadata.getBuildDependencies(), artifactSource);
                    this.allResolvedArtifacts.put(componentArtifactMetadata.getId(), resolvedArtifact);
                }
                resolvedArtifacts.add(resolvedArtifact);
            }
            result.add((Object)new DefaultResolvedVariant((AttributeContainer)attributes, ArtifactBackedArtifactSet.of(resolvedArtifacts)));
        }
        return new ArtifactSetSnapshot(this.id, (Set<ResolvedVariant>)result.build());
    }

    private static class DefaultResolvedVariant
    implements ResolvedVariant {
        private final AttributeContainer attributes;
        private final ResolvedArtifactSet artifactSet;

        DefaultResolvedVariant(AttributeContainer attributes, ResolvedArtifactSet artifactSet) {
            this.attributes = attributes;
            this.artifactSet = artifactSet;
        }

        public AttributeContainer getAttributes() {
            return this.attributes;
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this.artifactSet;
        }
    }

    private static class LazyArtifactSource
    implements Factory<File> {
        private final ArtifactResolver artifactResolver;
        private final ModuleSource moduleSource;
        private final ComponentArtifactMetadata artifact;

        private LazyArtifactSource(ComponentArtifactMetadata artifact, ModuleSource moduleSource, ArtifactResolver artifactResolver) {
            this.artifact = artifact;
            this.artifactResolver = artifactResolver;
            this.moduleSource = moduleSource;
        }

        public File create() {
            DefaultBuildableArtifactResolveResult result = new DefaultBuildableArtifactResolveResult();
            this.artifactResolver.resolveArtifact(this.artifact, this.moduleSource, result);
            return (File)result.getResult();
        }
    }

    private static class ArtifactSetSnapshot
    implements ArtifactSet {
        private final long id;
        private final Set<ResolvedVariant> variants;

        public ArtifactSetSnapshot(long id, Set<ResolvedVariant> variants) {
            this.id = id;
            this.variants = variants;
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        public ArtifactSet snapshot() {
            return this;
        }

        @Override
        public Set<? extends ResolvedVariant> getVariants() {
            return this.variants;
        }
    }
}

