/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.lang.reflect.Method;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.test.context.TestContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;
import org.springframework.transaction.interceptor.DelegatingTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class TestContextTransactionUtils {
    private static final Log logger = LogFactory.getLog(TestContextTransactionUtils.class);
    public static final String DEFAULT_DATA_SOURCE_NAME = "dataSource";
    public static final String DEFAULT_TRANSACTION_MANAGER_NAME = "transactionManager";

    private TestContextTransactionUtils() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSource retrieveDataSource(TestContext testContext, String name) {
        AutowireCapableBeanFactory bf;
        block8: {
            Assert.notNull((Object)testContext, (String)"TestContext must not be null");
            bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
            try {
                if (StringUtils.hasText((String)name)) {
                    return (DataSource)bf.getBean(name, DataSource.class);
                }
            }
            catch (BeansException ex) {
                logger.error((Object)String.format("Failed to retrieve DataSource named '%s' for test context %s", name, testContext), (Throwable)ex);
                throw ex;
            }
            if (!(bf instanceof ListableBeanFactory)) return (DataSource)bf.getBean(DEFAULT_DATA_SOURCE_NAME, DataSource.class);
            ListableBeanFactory lbf = (ListableBeanFactory)bf;
            Map dataSources = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, DataSource.class);
            if (dataSources.size() != 1) break block8;
            return (DataSource)dataSources.values().iterator().next();
            {
                catch (BeansException ex) {
                    TestContextTransactionUtils.logBeansException(testContext, ex, DataSource.class);
                    return null;
                }
            }
        }
        try {
            return (DataSource)bf.getBean(DataSource.class);
        }
        catch (BeansException ex) {
            TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
            return (DataSource)bf.getBean(DEFAULT_DATA_SOURCE_NAME, DataSource.class);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PlatformTransactionManager retrieveTransactionManager(TestContext testContext, String name) {
        ListableBeanFactory lbf;
        AutowireCapableBeanFactory bf;
        block9: {
            Assert.notNull((Object)testContext, (String)"TestContext must not be null");
            bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
            try {
                if (StringUtils.hasText((String)name)) {
                    return (PlatformTransactionManager)bf.getBean(name, PlatformTransactionManager.class);
                }
            }
            catch (BeansException ex) {
                logger.error((Object)String.format("Failed to retrieve transaction manager named '%s' for test context %s", name, testContext), (Throwable)ex);
                throw ex;
            }
            if (!(bf instanceof ListableBeanFactory)) return (PlatformTransactionManager)bf.getBean(DEFAULT_TRANSACTION_MANAGER_NAME, PlatformTransactionManager.class);
            lbf = (ListableBeanFactory)bf;
            Map txMgrs = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, PlatformTransactionManager.class);
            if (txMgrs.size() != 1) break block9;
            return (PlatformTransactionManager)txMgrs.values().iterator().next();
            {
                catch (BeansException ex) {
                    TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
                    return null;
                }
            }
        }
        try {
            return (PlatformTransactionManager)bf.getBean(PlatformTransactionManager.class);
        }
        catch (BeansException ex) {
            TestContextTransactionUtils.logBeansException(testContext, ex, PlatformTransactionManager.class);
            Map configurers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)lbf, TransactionManagementConfigurer.class);
            if (configurers.size() > 1) {
                throw new IllegalStateException("Only one TransactionManagementConfigurer may exist in the ApplicationContext");
            }
            if (configurers.size() != 1) return (PlatformTransactionManager)bf.getBean(DEFAULT_TRANSACTION_MANAGER_NAME, PlatformTransactionManager.class);
            return ((TransactionManagementConfigurer)configurers.values().iterator().next()).annotationDrivenTransactionManager();
        }
    }

    private static void logBeansException(TestContext testContext, BeansException ex, Class<?> beanType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Caught exception while retrieving %s for test context %s", beanType.getSimpleName(), testContext), (Throwable)ex);
        }
    }

    public static TransactionAttribute createDelegatingTransactionAttribute(TestContext testContext, TransactionAttribute targetAttribute) {
        Assert.notNull((Object)testContext, (String)"TestContext must not be null");
        Assert.notNull((Object)targetAttribute, (String)"Target TransactionAttribute must not be null");
        return new TestContextTransactionAttribute(targetAttribute, testContext);
    }

    private static class TestContextTransactionAttribute
    extends DelegatingTransactionAttribute {
        private final String name;

        public TestContextTransactionAttribute(TransactionAttribute targetAttribute, TestContext testContext) {
            super(targetAttribute);
            this.name = ClassUtils.getQualifiedMethodName((Method)testContext.getTestMethod(), testContext.getTestClass());
        }

        public String getName() {
            return this.name;
        }
    }
}

