/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ProxyPreferencesPanel
extends VerticallyScrollablePanel {
    public static final String PROXY_POLICY = "proxy.policy";
    public static final String PROXY_HTTP_HOST = "proxy.http.host";
    public static final String PROXY_HTTP_PORT = "proxy.http.port";
    public static final String PROXY_SOCKS_HOST = "proxy.socks.host";
    public static final String PROXY_SOCKS_PORT = "proxy.socks.port";
    public static final String PROXY_USER = "proxy.user";
    public static final String PROXY_PASS = "proxy.pass";
    public static final String PROXY_EXCEPTIONS = "proxy.exceptions";
    private transient Map<ProxyPolicy, JRadioButton> rbProxyPolicy;
    private final JosmTextField tfProxyHttpHost = new JosmTextField();
    private final JosmTextField tfProxyHttpPort = new JosmTextField(5);
    private final JosmTextField tfProxySocksHost = new JosmTextField(20);
    private final JosmTextField tfProxySocksPort = new JosmTextField(5);
    private final JosmTextField tfProxyHttpUser = new JosmTextField(20);
    private final JosmPasswordField tfProxyHttpPassword = new JosmPasswordField(20);
    private JPanel pnlHttpProxyConfigurationPanel;
    private JPanel pnlSocksProxyConfigurationPanel;

    protected final JPanel buildHttpProxyConfigurationPanel() {
        AutoSizePanel autoSizePanel = new AutoSizePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        autoSizePanel.add((Component)new JLabel(I18n.tr("Host:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        autoSizePanel.add((Component)this.tfProxyHttpHost, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        autoSizePanel.add((Component)new JLabel(I18n.trc("server", "Port:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        autoSizePanel.add((Component)this.tfProxyHttpPort, gridBagConstraints);
        this.tfProxyHttpPort.setMinimumSize(this.tfProxyHttpPort.getPreferredSize());
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        autoSizePanel.add((Component)new JMultilineLabel(I18n.tr("Please enter a username and a password if your proxy requires authentication.", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        autoSizePanel.add((Component)new JLabel(I18n.tr("User:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        autoSizePanel.add((Component)this.tfProxyHttpUser, gridBagConstraints);
        this.tfProxyHttpUser.setMinimumSize(this.tfProxyHttpUser.getPreferredSize());
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        autoSizePanel.add((Component)new JLabel(I18n.tr("Password:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        autoSizePanel.add((Component)this.tfProxyHttpPassword, gridBagConstraints);
        this.tfProxyHttpPassword.setMinimumSize(this.tfProxyHttpPassword.getPreferredSize());
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        autoSizePanel.add((Component)new JPanel(), gridBagConstraints);
        return autoSizePanel;
    }

    protected final JPanel buildSocksProxyConfigurationPanel() {
        AutoSizePanel autoSizePanel = new AutoSizePanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        autoSizePanel.add((Component)new JLabel(I18n.tr("Host:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        autoSizePanel.add((Component)this.tfProxySocksHost, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        autoSizePanel.add((Component)new JLabel(I18n.trc("server", "Port:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        autoSizePanel.add((Component)this.tfProxySocksPort, gridBagConstraints);
        this.tfProxySocksPort.setMinimumSize(this.tfProxySocksPort.getPreferredSize());
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        autoSizePanel.add((Component)new JPanel(), gridBagConstraints);
        return autoSizePanel;
    }

    /*
     * WARNING - void declaration
     */
    protected final JPanel buildProxySettingsPanel() {
        void var5_8;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbProxyPolicy = new EnumMap<ProxyPolicy, JRadioButton>(ProxyPolicy.class);
        ProxyPolicyChangeListener proxyPolicyChangeListener = new ProxyPolicyChangeListener();
        for (ProxyPolicy proxyPolicy : ProxyPolicy.values()) {
            this.rbProxyPolicy.put(proxyPolicy, new JRadioButton());
            buttonGroup.add(this.rbProxyPolicy.get((Object)proxyPolicy));
            this.rbProxyPolicy.get((Object)proxyPolicy).addItemListener(proxyPolicyChangeListener);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.NO_PROXY), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(I18n.tr("No proxy", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SYSTEM_SETTINGS), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        if (DefaultProxySelector.willJvmRetrieveSystemProxies()) {
            String string = I18n.tr("Use standard system settings", new Object[0]);
        } else {
            String string = I18n.tr("Use standard system settings (disabled. Start JOSM with <tt>-Djava.net.useSystemProxies=true</tt> to enable)", new Object[0]);
        }
        jPanel.add((Component)new JMultilineLabel("<html>" + (String)var5_8 + "</html>"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_HTTP_PROXY), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(I18n.tr("Manually configure a HTTP proxy", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.pnlHttpProxyConfigurationPanel = this.buildHttpProxyConfigurationPanel();
        jPanel.add((Component)this.pnlHttpProxyConfigurationPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SOCKS_PROXY), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(I18n.tr("Use a SOCKS proxy", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.pnlSocksProxyConfigurationPanel = this.buildSocksProxyConfigurationPanel();
        jPanel.add((Component)this.pnlSocksProxyConfigurationPanel, gridBagConstraints);
        return jPanel;
    }

    public final void initFromPreferences() {
        String string = Main.pref.get(PROXY_POLICY, null);
        ProxyPolicy proxyPolicy = ProxyPolicy.fromName(string);
        if (proxyPolicy == null) {
            proxyPolicy = ProxyPolicy.NO_PROXY;
        }
        this.rbProxyPolicy.get((Object)proxyPolicy).setSelected(true);
        String string2 = Main.pref.get("proxy.host", null);
        if (string2 != null) {
            this.tfProxyHttpHost.setText(string2);
            Main.pref.put("proxy.host", null);
        } else {
            this.tfProxyHttpHost.setText(Main.pref.get(PROXY_HTTP_HOST, ""));
        }
        string2 = Main.pref.get("proxy.port", null);
        if (string2 != null) {
            this.tfProxyHttpPort.setText(string2);
            Main.pref.put("proxy.port", null);
        } else {
            this.tfProxyHttpPort.setText(Main.pref.get(PROXY_HTTP_PORT, ""));
        }
        this.tfProxySocksHost.setText(Main.pref.get(PROXY_SOCKS_HOST, ""));
        this.tfProxySocksPort.setText(Main.pref.get(PROXY_SOCKS_PORT, ""));
        if (proxyPolicy.equals((Object)ProxyPolicy.USE_SYSTEM_SETTINGS) && !DefaultProxySelector.willJvmRetrieveSystemProxies()) {
            Main.warn(I18n.tr("JOSM is configured to use proxies from the system setting, but the JVM is not configured to retrieve them. Resetting preferences to ''No proxy''", new Object[0]));
            proxyPolicy = ProxyPolicy.NO_PROXY;
            this.rbProxyPolicy.get((Object)proxyPolicy).setSelected(true);
        }
        CredentialsManager credentialsManager = CredentialsManager.getInstance();
        try {
            PasswordAuthentication passwordAuthentication = credentialsManager.lookup(Authenticator.RequestorType.PROXY, this.tfProxyHttpHost.getText());
            if (passwordAuthentication == null) {
                this.tfProxyHttpUser.setText("");
                this.tfProxyHttpPassword.setText("");
            } else {
                this.tfProxyHttpUser.setText(passwordAuthentication.getUserName() == null ? "" : passwordAuthentication.getUserName());
                this.tfProxyHttpPassword.setText(passwordAuthentication.getPassword() == null ? "" : String.valueOf(passwordAuthentication.getPassword()));
            }
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.error(credentialsAgentException);
            this.tfProxyHttpUser.setText("");
            this.tfProxyHttpPassword.setText("");
        }
    }

    protected final void updateEnabledState() {
        boolean bl = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_HTTP_PROXY).isSelected();
        for (Component component : this.pnlHttpProxyConfigurationPanel.getComponents()) {
            component.setEnabled(bl);
        }
        boolean bl2 = this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SOCKS_PROXY).isSelected();
        for (Component component : this.pnlSocksProxyConfigurationPanel.getComponents()) {
            component.setEnabled(bl2);
        }
        this.rbProxyPolicy.get((Object)ProxyPolicy.USE_SYSTEM_SETTINGS).setEnabled(DefaultProxySelector.willJvmRetrieveSystemProxies());
    }

    public ProxyPreferencesPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildProxySettingsPanel(), GBC.eop().anchor(18).fill(1));
        this.initFromPreferences();
        this.updateEnabledState();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ProxySettings"));
    }

    public void saveToPreferences() {
        ProxyPolicy proxyPolicy = null;
        for (ProxyPolicy proxyPolicy2 : ProxyPolicy.values()) {
            if (!this.rbProxyPolicy.get((Object)proxyPolicy2).isSelected()) continue;
            proxyPolicy = proxyPolicy2;
            break;
        }
        if (proxyPolicy == null) {
            proxyPolicy = ProxyPolicy.NO_PROXY;
        }
        Main.pref.put(PROXY_POLICY, proxyPolicy.getName());
        Main.pref.put(PROXY_HTTP_HOST, this.tfProxyHttpHost.getText());
        Main.pref.put(PROXY_HTTP_PORT, this.tfProxyHttpPort.getText());
        Main.pref.put(PROXY_SOCKS_HOST, this.tfProxySocksHost.getText());
        Main.pref.put(PROXY_SOCKS_PORT, this.tfProxySocksPort.getText());
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector instanceof DefaultProxySelector) {
            ((DefaultProxySelector)proxySelector).initFromPreferences();
        }
        CredentialsManager credentialsManager = CredentialsManager.getInstance();
        try {
            PasswordAuthentication credentialsAgentException = new PasswordAuthentication(this.tfProxyHttpUser.getText().trim(), this.tfProxyHttpPassword.getPassword());
            credentialsManager.store(Authenticator.RequestorType.PROXY, this.tfProxyHttpHost.getText(), credentialsAgentException);
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Main.error(credentialsAgentException);
        }
    }

    class ProxyPolicyChangeListener
    implements ItemListener {
        ProxyPolicyChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ProxyPreferencesPanel.this.updateEnabledState();
        }
    }

    public static enum ProxyPolicy {
        NO_PROXY("no-proxy"),
        USE_SYSTEM_SETTINGS("use-system-settings"),
        USE_HTTP_PROXY("use-http-proxy"),
        USE_SOCKS_PROXY("use-socks-proxy");

        private final String policyName;

        private ProxyPolicy(String string2) {
            this.policyName = string2;
        }

        public String getName() {
            return this.policyName;
        }

        public static ProxyPolicy fromName(String string) {
            if (string == null) {
                return null;
            }
            string = string.trim().toLowerCase(Locale.ENGLISH);
            for (ProxyPolicy proxyPolicy : ProxyPolicy.values()) {
                if (!proxyPolicy.getName().equals(string)) continue;
                return proxyPolicy;
            }
            return null;
        }
    }

    static final class AutoSizePanel
    extends JPanel {
        AutoSizePanel() {
            super(new GridBagLayout());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

