/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.algorithms;

public class Randomizer {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UMASK = Integer.MIN_VALUE;
    private static final int LMASK = Integer.MAX_VALUE;
    private final int[] state = new int[624];
    private int left = 1;

    public Randomizer() {
    }

    public Randomizer(int s) {
        this.state[0] = s;
        for (int j = 1; j < 624; ++j) {
            this.state[j] = 1812433253 * (this.state[j - 1] ^ this.state[j - 1] >>> 30) + j;
        }
        this.left = 1;
    }

    public Randomizer(int[] initKey) {
        this(19650218);
        int k;
        int len = initKey.length;
        int i = 1;
        int j = 0;
        int n = k = 624 > len ? 624 : len;
        while (k > 0) {
            this.state[i] = (this.state[i] ^ (this.state[i - 1] ^ this.state[i - 1] >>> 30) * 1664525) + initKey[j] + j;
            ++j;
            if (++i >= 624) {
                this.state[0] = this.state[623];
                i = 1;
            }
            if (j >= len) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k > 0; --k) {
            this.state[i] = (this.state[i] ^ (this.state[i - 1] ^ this.state[i - 1] >>> 30) * 1566083941) - i;
            if (++i < 624) continue;
            this.state[0] = this.state[623];
            i = 1;
        }
        this.state[0] = Integer.MIN_VALUE;
    }

    public static Randomizer randomFromLong(long seed) {
        long v = Math.abs(seed);
        if (v == (v & 0xFFFFFFFFL)) {
            return new Randomizer((int)v);
        }
        int[] ints = new int[]{(int)v, (int)(v >> 32)};
        return new Randomizer(ints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int genrandInt32() {
        int y;
        Randomizer randomizer = this;
        synchronized (randomizer) {
            if (--this.left <= 0) {
                this.nextState();
            }
            y = this.state[624 - this.left];
        }
        y ^= y >>> 11;
        y = (int)((long)y ^ (long)(y << 7) & 0x9D2C5680L);
        y = (int)((long)y ^ (long)(y << 15) & 0xEFC60000L);
        y ^= y >>> 18;
        return y;
    }

    private void nextState() {
        int p = 0;
        this.left = 624;
        int j = 228;
        while (--j > 0) {
            this.state[p] = this.state[p + 397] ^ Randomizer.twist(this.state[p + 0], this.state[p + 1]);
            ++p;
        }
        j = 397;
        while (--j > 0) {
            this.state[p] = this.state[p + 397 - 624] ^ Randomizer.twist(this.state[p + 0], this.state[p + 1]);
            ++p;
        }
        this.state[p] = this.state[p + 397 - 624] ^ Randomizer.twist(this.state[p + 0], this.state[0]);
    }

    private static int mixbits(int u, int v) {
        return u & Integer.MIN_VALUE | v & Integer.MAX_VALUE;
    }

    private static int twist(int u, int v) {
        return Randomizer.mixbits(u, v) >>> 1 ^ ((v & 1) != 0 ? -1727483681 : 0);
    }
}

