/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import java.util.Random;

public class Hashing {
    private static final boolean SIPHASH_ENABLED = false;
    private static final boolean CONSISTENT_HASHING_ENABLED = false;
    private static final int MURMUR2_MAGIC = 1540483477;
    public static final long SEED_K0;
    public static final long SEED_K1;

    public static long hash(long seed, long value) {
        return Hashing.end(Hashing.update(Hashing.start(seed), value));
    }

    public static long start(long value) {
        long hash = value;
        return hash += SEED_K1;
    }

    public static long update(long hash, long value) {
        long v = 0L;
        v = Hashing.murmur1(v + (hash += value));
        v = Hashing.murmur1(v + (hash >>> 32));
        return v;
    }

    public static long end(long hash) {
        hash = Hashing.murmur_step(hash, 10L);
        hash = Hashing.murmur_step(hash, 17L);
        return hash;
    }

    private static long murmur1(long h) {
        return Hashing.murmur_step(h, 16L);
    }

    public static long murmur_step(long h, long k) {
        return Hashing.murmur(h, k, 16);
    }

    public static long murmur(long h, long k, int r) {
        long m = 1540483477L;
        h += k;
        h *= m;
        h ^= h >> r;
        return h;
    }

    static {
        Random random = new Random();
        SEED_K0 = random.nextLong();
        SEED_K1 = random.nextLong();
    }
}

