/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.exceptions.OutsideOfStringException;

public class AdvanceSourcePositionNode
extends FormatNode {
    private final boolean toEnd;
    private final ConditionProfile rangeProfile = ConditionProfile.createBinaryProfile();

    public AdvanceSourcePositionNode(boolean toEnd) {
        this.toEnd = toEnd;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.toEnd) {
            this.setSourcePosition(frame, this.getSourceLength(frame));
        } else {
            int position = this.getSourcePosition(frame);
            if (this.rangeProfile.profile(position + 1 > this.getSourceLength(frame))) {
                throw new OutsideOfStringException();
            }
            this.setSourcePosition(frame, this.getSourcePosition(frame) + 1);
        }
        return null;
    }
}

