/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.core.basicobject.BasicObjectNodesFactory;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.language.RubyBaseNode;

public class CompareHashKeysNode
extends RubyBaseNode {
    @Node.Child
    private KernelNodes.SameOrEqlNode sameOrEqlNode;
    @Node.Child
    private BasicObjectNodes.ReferenceEqualNode equalNode;

    public boolean equalKeys(VirtualFrame frame, boolean compareByIdentity, Object key, int hashed, Object otherKey, int otherHashed) {
        if (compareByIdentity) {
            return this.equal(key, otherKey);
        }
        return hashed == otherHashed && this.sameOrEql(frame, key, otherKey);
    }

    private boolean sameOrEql(VirtualFrame frame, Object key1, Object key2) {
        if (this.sameOrEqlNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.sameOrEqlNode = this.insert(KernelNodesFactory.SameOrEqlNodeFactory.create(null));
        }
        return this.sameOrEqlNode.executeSameOrEql(frame, key1, key2);
    }

    private boolean equal(Object key1, Object key2) {
        if (this.equalNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.equalNode = this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(null));
        }
        return this.equalNode.executeReferenceEqual(key1, key2);
    }
}

