/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;

public class SubstringRope
extends Rope {
    private final Rope child;
    private final int offset;

    public SubstringRope(Rope child, int offset, int byteLength, int characterLength, CodeRange codeRange) {
        this(child, child.getEncoding(), child.isSingleByteOptimizable(), offset, byteLength, characterLength, codeRange);
    }

    public SubstringRope(Rope child, boolean singleByteOptimizable, int offset, int byteLength, int characterLength, CodeRange codeRange) {
        this(child, child.getEncoding(), singleByteOptimizable, offset, byteLength, characterLength, codeRange);
    }

    private SubstringRope(Rope child, Encoding encoding, boolean singleByteOptimizable, int offset, int byteLength, int characterLength, CodeRange codeRange) {
        super(encoding, codeRange, singleByteOptimizable, byteLength, characterLength, child.depth() + 1, null);
        this.child = child;
        this.offset = offset;
        assert (byteLength <= child.byteLength());
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        if (newCodeRange != this.getCodeRange()) {
            throw new UnsupportedOperationException("Cannot fast-path updating encoding with different code range.");
        }
        return new SubstringRope(this.getChild(), newEncoding, this.getChild().isSingleByteOptimizable(), this.getOffset(), this.byteLength(), this.characterLength(), newCodeRange);
    }

    @Override
    protected byte[] getBytesSlow() {
        if (this.child.getRawBytes() != null) {
            byte[] ret = new byte[this.byteLength()];
            System.arraycopy(this.child.getRawBytes(), this.offset, ret, 0, this.byteLength());
            return ret;
        }
        return RopeOperations.flattenBytes(this);
    }

    @Override
    public byte getByteSlow(int index) {
        return this.child.getByteSlow(index + this.offset);
    }

    public Rope getChild() {
        return this.child;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        byte[] childBytes = RopeOperations.extractRange(this.child, this.offset, this.byteLength());
        return RopeOperations.decodeUTF8(childBytes, 0, childBytes.length);
    }
}

