/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.ffi.Runtime;
import jnr.posix.DefaultNativeTimeval;
import jnr.posix.Timeval;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.rope.BytesVisitor;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.extra.ffi.PointerPrimitiveNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.platform.FDSet;
import org.jruby.truffle.platform.Platform;
import org.jruby.truffle.platform.UnsafeGroup;

public abstract class IOPrimitiveNodes {
    private static final int STDOUT = 1;

    @Primitive(name="io_select", needsSelf=false, lowerFixnum={4}, unsafe={UnsafeGroup.IO})
    public static abstract class IOSelectPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        public abstract Object executeSelect(DynamicObject var1, DynamicObject var2, DynamicObject var3, Object var4);

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isNil(noTimeout)"})
        public Object select(DynamicObject readables, DynamicObject writables, DynamicObject errorables, DynamicObject noTimeout) {
            Object result;
            while ((result = this.executeSelect(readables, writables, errorables, Integer.MAX_VALUE)) == this.nil()) {
            }
            return result;
        }

        @Specialization(guards={"isRubyArray(readables)", "isNilOrEmpty(writables)", "isNilOrEmpty(errorables)"})
        public Object selectReadables(DynamicObject readables, DynamicObject writables, DynamicObject errorables, int timeoutMicros) {
            return this.selectOneSet(readables, timeoutMicros, 1);
        }

        @Specialization(guards={"isNilOrEmpty(readables)", "isRubyArray(writables)", "isNilOrEmpty(errorables)"})
        public Object selectWritables(DynamicObject readables, DynamicObject writables, DynamicObject errorables, int timeoutMicros) {
            return this.selectOneSet(writables, timeoutMicros, 2);
        }

        @Specialization(guards={"isNilOrEmpty(readables)", "isNilOrEmpty(writables)", "isRubyArray(errorables)"})
        public Object selectErrorables(DynamicObject readables, DynamicObject writables, DynamicObject errorables, int timeoutMicros) {
            return this.selectOneSet(errorables, timeoutMicros, 3);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        private Object selectOneSet(DynamicObject setToSelect, final int timeoutMicros, final int setNb) {
            assert (setNb >= 1 && setNb <= 3);
            Object[] readableObjects = ArrayOperations.toObjectArray(setToSelect);
            final int[] fds = this.getFileDescriptors(setToSelect);
            final int nfds = IOSelectPrimitiveNode.max(fds) + 1;
            final FDSet fdSet = this.getContext().getNativePlatform().createFDSet();
            ThreadManager.ResultOrTimeout<Integer> resultOrTimeout = this.getContext().getThreadManager().runUntilTimeout(this, timeoutMicros, new ThreadManager.BlockingTimeoutAction<Integer>(){

                @Override
                public Integer block(Timeval timeoutToUse) throws InterruptedException {
                    for (int fd : fds) {
                        fdSet.set(fd);
                    }
                    int result = this.callSelect(nfds, fdSet, timeoutToUse);
                    if (result == 0 && timeoutMicros != 0) {
                        return null;
                    }
                    return result;
                }

                private int callSelect(int nfds2, FDSet fdSet2, Timeval timeoutToUse) {
                    return this.nativeSockets().select(nfds2, setNb == 1 ? fdSet2.getPointer() : PointerPrimitiveNodes.NULL_POINTER, setNb == 2 ? fdSet2.getPointer() : PointerPrimitiveNodes.NULL_POINTER, setNb == 3 ? fdSet2.getPointer() : PointerPrimitiveNodes.NULL_POINTER, timeoutToUse);
                }
            });
            if (resultOrTimeout instanceof ThreadManager.TimedOut) {
                return this.nil();
            }
            ThreadManager.ResultWithinTime result = (ThreadManager.ResultWithinTime)resultOrTimeout;
            int resultCode = this.ensureSuccessful((Integer)result.getValue());
            if (resultCode == 0) {
                return this.nil();
            }
            return this.createArray(new Object[]{setNb == 1 ? this.getSetObjects(readableObjects, fds, fdSet) : this.createEmptyArray(), setNb == 2 ? this.getSetObjects(readableObjects, fds, fdSet) : this.createEmptyArray(), setNb == 3 ? this.getSetObjects(readableObjects, fds, fdSet) : this.createEmptyArray()}, 3);
        }

        public DynamicObject createEmptyArray() {
            return this.createArray(null, 0);
        }

        private int[] getFileDescriptors(DynamicObject fileDescriptorArray) {
            assert (RubyGuards.isRubyArray(fileDescriptorArray));
            Object[] objects = ArrayOperations.toObjectArray(fileDescriptorArray);
            int[] fileDescriptors = new int[objects.length];
            for (int n = 0; n < objects.length; ++n) {
                if (!(objects[n] instanceof DynamicObject)) {
                    throw new UnsupportedOperationException();
                }
                fileDescriptors[n] = Layouts.IO.getDescriptor((DynamicObject)objects[n]);
            }
            return fileDescriptors;
        }

        private static int max(int[] values) {
            assert (values.length > 0);
            int max = Integer.MIN_VALUE;
            for (int n = 0; n < values.length; ++n) {
                max = Math.max(max, values[n]);
            }
            return max;
        }

        private DynamicObject getSetObjects(Object[] objects, int[] fds, FDSet set) {
            Object[] setObjects = new Object[objects.length];
            int setFdsCount = 0;
            for (int n = 0; n < objects.length; ++n) {
                if (!set.isSet(fds[n])) continue;
                setObjects[setFdsCount] = objects[n];
                ++setFdsCount;
            }
            return this.createArray(setObjects, setFdsCount);
        }

        protected boolean isNilOrEmpty(DynamicObject fds) {
            return this.isNil(fds) || RubyGuards.isRubyArray(fds) && ArrayGuards.isEmptyArray(fds);
        }
    }

    @Primitive(name="io_sysread", unsafe={UnsafeGroup.IO}, lowerFixnum={1})
    public static abstract class IOSysReadPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public DynamicObject sysread(DynamicObject file, int length) {
            int bytesRead;
            int fd = Layouts.IO.getDescriptor(file);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            for (int toRead = length; toRead > 0; toRead -= bytesRead) {
                this.getContext().getSafepointManager().poll(this);
                bytesRead = this.ensureSuccessful(this.posix().read(fd, buffer, toRead));
                if (bytesRead == 0) {
                    if (toRead != length) break;
                    return this.nil();
                }
                buffer.position(bytesRead);
            }
            return this.createString(new ByteList(buffer.array(), buffer.arrayOffset(), buffer.position(), false));
        }
    }

    @Primitive(name="io_accept", unsafe={UnsafeGroup.IO})
    public static abstract class AcceptNode
    extends IOPrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public int accept(DynamicObject io) {
            int newFd;
            int fd = Layouts.IO.getDescriptor(io);
            int[] addressLength = new int[]{16};
            long address = this.getContext().getNativePlatform().getMallocFree().malloc(addressLength[0]);
            try {
                newFd = this.ensureSuccessful(this.nativeSockets().accept(fd, this.memoryManager().newPointer(address), addressLength));
            }
            finally {
                this.getContext().getNativePlatform().getMallocFree().free(address);
            }
            return newFd;
        }
    }

    @Primitive(name="io_seek", lowerFixnum={1, 2}, unsafe={UnsafeGroup.IO})
    public static abstract class IOSeekPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @Specialization
        public int seek(DynamicObject io, int amount, int whence) {
            int fd = Layouts.IO.getDescriptor(io);
            return this.ensureSuccessful(this.posix().lseek(fd, amount, whence));
        }
    }

    @Primitive(name="io_close", unsafe={UnsafeGroup.IO})
    public static abstract class IOClosePrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode ensureOpenNode = DispatchHeadNodeFactory.createMethodCall();

        @Specialization
        public int close(VirtualFrame frame, DynamicObject io) {
            this.ensureOpenNode.call(frame, io, "ensure_open", new Object[0]);
            int fd = Layouts.IO.getDescriptor(io);
            if (fd == -1) {
                return 0;
            }
            int newDescriptor = -1;
            Layouts.IO.setDescriptor(io, newDescriptor);
            if (fd < 3) {
                return 0;
            }
            this.ensureSuccessful(this.posix().close(fd));
            return 0;
        }
    }

    @Primitive(name="io_write_nonblock", unsafe={UnsafeGroup.IO})
    public static abstract class IOWriteNonBlockPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(string)"})
        public int writeNonBlock(DynamicObject io, DynamicObject string) {
            this.setNonBlocking(io);
            final int fd = Layouts.IO.getDescriptor(io);
            Rope rope = StringOperations.rope(string);
            if (this.getContext().getDebugStandardOut() != null && fd == 1) {
                this.getContext().getDebugStandardOut().write(rope.getBytes(), 0, rope.byteLength());
                return rope.byteLength();
            }
            final IOWriteNonBlockPrimitiveNode currentNode = this;
            try {
                RopeOperations.visitBytes(rope, new BytesVisitor(){
                    int totalWritten = 0;

                    @Override
                    public void accept(byte[] bytes, int offset, int length) {
                        ByteBuffer buffer = ByteBuffer.wrap(bytes, offset, length);
                        while (buffer.hasRemaining()) {
                            this.getContext().getSafepointManager().poll(currentNode);
                            int result = this.posix().write(fd, buffer, buffer.remaining());
                            if (result <= 0) {
                                int errno = this.posix().errno();
                                if (errno == Errno.EAGAIN.intValue() || errno == Errno.EWOULDBLOCK.intValue()) {
                                    throw new RaiseException(this.coreExceptions().eAGAINWaitWritable(currentNode));
                                }
                                this.ensureSuccessful(result);
                            } else {
                                this.totalWritten += result;
                            }
                            if (result < buffer.remaining()) {
                                throw new StopWriting(this.totalWritten);
                            }
                            buffer.position(buffer.position() + result);
                        }
                    }
                });
            }
            catch (StopWriting e) {
                return e.bytesWritten;
            }
            return rope.byteLength();
        }

        protected void setNonBlocking(DynamicObject io) {
            int fd = Layouts.IO.getDescriptor(io);
            int flags = this.ensureSuccessful(this.posix().fcntl(fd, Fcntl.F_GETFL));
            if ((flags & OpenFlags.O_NONBLOCK.intValue()) == 0) {
                this.ensureSuccessful(this.posix().fcntlInt(fd, Fcntl.F_SETFL, flags |= OpenFlags.O_NONBLOCK.intValue()));
                Layouts.IO.setMode(io, flags);
            }
        }

        static class StopWriting
        extends ControlFlowException {
            private static final long serialVersionUID = 1096318435617097172L;
            final int bytesWritten;

            public StopWriting(int bytesWritten) {
                this.bytesWritten = bytesWritten;
            }
        }
    }

    @Primitive(name="io_write", unsafe={UnsafeGroup.IO})
    public static abstract class IOWritePrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(string)"})
        public int write(DynamicObject file, DynamicObject string) {
            int fd = Layouts.IO.getDescriptor(file);
            Rope rope = StringOperations.rope(string);
            if (this.getContext().getDebugStandardOut() != null && fd == 1) {
                this.getContext().getDebugStandardOut().write(rope.getBytes(), 0, rope.byteLength());
                return rope.byteLength();
            }
            RopeOperations.visitBytes(rope, (bytes, offset, length) -> {
                ByteBuffer buffer = ByteBuffer.wrap(bytes, offset, length);
                while (buffer.hasRemaining()) {
                    this.getContext().getSafepointManager().poll(this);
                    int written = this.ensureSuccessful(this.posix().write(fd, buffer, buffer.remaining()));
                    buffer.position(buffer.position() + written);
                }
            });
            return rope.byteLength();
        }
    }

    @Primitive(name="io_reopen_path", lowerFixnum={2}, unsafe={UnsafeGroup.IO})
    public static abstract class IOReopenPathPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode = DispatchHeadNodeFactory.createMethodCall();

        /*
         * Enabled aggressive block sorting
         */
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        public void performReopenPath(DynamicObject self, DynamicObject path, int mode) {
            int newFdSelf;
            block4: {
                int fdSelf = Layouts.IO.getDescriptor(self);
                String targetPathString = StringOperations.getString(path);
                int fdTarget = this.ensureSuccessful(this.posix().open(targetPathString, mode, 438));
                int result = this.posix().dup2(fdTarget, fdSelf);
                if (result == -1) {
                    int errno = this.posix().errno();
                    if (errno == Errno.EBADF.intValue()) {
                        Layouts.IO.setDescriptor(self, fdTarget);
                        newFdSelf = fdTarget;
                        break block4;
                    } else {
                        if (fdTarget > 0) {
                            this.ensureSuccessful(this.posix().close(fdTarget));
                        }
                        this.ensureSuccessful(result, errno, targetPathString);
                        return;
                    }
                }
                this.ensureSuccessful(this.posix().close(fdTarget));
                newFdSelf = fdSelf;
            }
            int newSelfMode = this.ensureSuccessful(this.posix().fcntl(newFdSelf, Fcntl.F_GETFL));
            Layouts.IO.setMode(self, newSelfMode);
        }

        @Specialization(guards={"isRubyString(path)"})
        public Object reopenPath(VirtualFrame frame, DynamicObject file, DynamicObject path, int mode) {
            this.performReopenPath(file, path, mode);
            this.resetBufferingNode.call(frame, file, "reset_buffering", new Object[0]);
            return this.nil();
        }
    }

    @Primitive(name="io_reopen", unsafe={UnsafeGroup.IO})
    public static abstract class IOReopenPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode = DispatchHeadNodeFactory.createMethodCall();

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        private void performReopen(DynamicObject self, DynamicObject target) {
            int fdSelf = Layouts.IO.getDescriptor(self);
            int fdTarget = Layouts.IO.getDescriptor(target);
            this.ensureSuccessful(this.posix().dup2(fdTarget, fdSelf));
            int newSelfMode = this.ensureSuccessful(this.posix().fcntl(fdSelf, Fcntl.F_GETFL));
            Layouts.IO.setMode(self, newSelfMode);
        }

        @Specialization
        public Object reopen(VirtualFrame frame, DynamicObject file, DynamicObject io) {
            this.performReopen(file, io);
            this.resetBufferingNode.call(frame, io, "reset_buffering", new Object[0]);
            return this.nil();
        }
    }

    @Primitive(name="io_read_if_available", lowerFixnum={1}, unsafe={UnsafeGroup.IO})
    public static abstract class IOReadIfAvailableNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public Object readIfAvailable(DynamicObject file, int numberOfBytes) {
            if (numberOfBytes == 0) {
                return this.createString(RopeConstants.EMPTY_ASCII_8BIT_ROPE);
            }
            int fd = Layouts.IO.getDescriptor(file);
            FDSet fdSet = this.getContext().getNativePlatform().createFDSet();
            fdSet.set(fd);
            DefaultNativeTimeval timeoutObject = new DefaultNativeTimeval(Runtime.getSystemRuntime());
            ((Timeval)timeoutObject).setTime(new long[]{0L, 0L});
            int res = this.ensureSuccessful(this.nativeSockets().select(fd + 1, fdSet.getPointer(), PointerPrimitiveNodes.NULL_POINTER, PointerPrimitiveNodes.NULL_POINTER, timeoutObject));
            if (res == 0) {
                throw new RaiseException(this.coreExceptions().eAGAINWaitReadable(this));
            }
            byte[] bytes = new byte[numberOfBytes];
            int bytesRead = this.ensureSuccessful(this.posix().read(fd, bytes, numberOfBytes));
            if (bytesRead == 0) {
                return this.nil();
            }
            return this.createString(new ByteList(bytes, 0, bytesRead, false));
        }
    }

    @Primitive(name="io_socket_read", lowerFixnum={1, 2, 3, 4}, unsafe={UnsafeGroup.IO})
    public static abstract class IOSocketReadNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization
        public Object socketRead(DynamicObject io, int length, int flags, int type) {
            int sockfd = Layouts.IO.getDescriptor(io);
            if (type != 0) {
                throw new UnsupportedOperationException();
            }
            ByteBuffer buffer = ByteBuffer.allocate(length);
            int bytesRead = this.getContext().getThreadManager().runUntilResult(this, () -> this.ensureSuccessful(this.nativeSockets().recvfrom(sockfd, buffer, length, flags, PointerPrimitiveNodes.NULL_POINTER, PointerPrimitiveNodes.NULL_POINTER)));
            buffer.position(bytesRead);
            return this.createString(new ByteList(buffer.array(), buffer.arrayOffset(), buffer.position(), false));
        }
    }

    @Primitive(name="io_ensure_open", unsafe={UnsafeGroup.IO})
    public static abstract class IOEnsureOpenPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject ensureOpen(VirtualFrame frame, DynamicObject file, @Cached(value="create()") BranchProfile errorProfile) {
            int fd = Layouts.IO.getDescriptor(file);
            if (fd == -1) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().ioError("closed stream", this));
            }
            if (fd == -2) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().ioError("shutdown stream", this));
            }
            return this.nil();
        }
    }

    @Primitive(name="io_fnmatch", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class IOFNMatchPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        private static final boolean DOSISH = Platform.IS_WINDOWS;
        private static final int FNM_NOESCAPE = 1;
        private static final int FNM_PATHNAME = 2;
        private static final int FNM_DOTMATCH = 4;
        private static final int FNM_CASEFOLD = 8;
        public static final int FNM_NOMATCH = 1;

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)", "isRubyString(path)"})
        public boolean fnmatch(DynamicObject pattern, DynamicObject path, int flags) {
            Rope patternRope = StringOperations.rope(pattern);
            Rope pathRope = StringOperations.rope(path);
            return IOFNMatchPrimitiveNode.fnmatch(patternRope.getBytes(), 0, patternRope.byteLength(), pathRope.getBytes(), 0, pathRope.byteLength(), flags) != 1;
        }

        private static boolean isdirsep(char c) {
            return c == '/' || DOSISH && c == '\\';
        }

        private static boolean isdirsep(byte c) {
            return IOFNMatchPrimitiveNode.isdirsep((char)(c & 0xFF));
        }

        private static int rb_path_next(byte[] _s, int s, int send) {
            while (s < send && !IOFNMatchPrimitiveNode.isdirsep(_s[s])) {
                ++s;
            }
            return s;
        }

        private static int fnmatch_helper(byte[] bytes, int pstart, int pend, byte[] string, int sstart, int send, int flags) {
            boolean nocase;
            int s = sstart;
            int pat = pstart;
            boolean escape = (flags & 1) == 0;
            boolean pathname = (flags & 2) != 0;
            boolean period = (flags & 4) == 0;
            boolean bl = nocase = (flags & 8) != 0;
            block6: while (pat < pend) {
                int c = bytes[pat++] & 0xFF;
                switch (c) {
                    case 63: {
                        if (s >= send || pathname && IOFNMatchPrimitiveNode.isdirsep(string[s]) || period && string[s] == 46 && (s == 0 || pathname && IOFNMatchPrimitiveNode.isdirsep(string[s - 1]))) {
                            return 1;
                        }
                        ++s;
                        continue block6;
                    }
                    case 42: {
                        while (pat < pend && (c = (int)(bytes[pat++] & 0xFF)) == 42) {
                        }
                        if (s < send && period && string[s] == 46 && (s == 0 || pathname && IOFNMatchPrimitiveNode.isdirsep(string[s - 1]))) {
                            return 1;
                        }
                        if (pat > pend || pat == pend && c == 42) {
                            if (pathname && IOFNMatchPrimitiveNode.rb_path_next(string, s, send) < send) {
                                return 1;
                            }
                            return 0;
                        }
                        if (pathname && IOFNMatchPrimitiveNode.isdirsep((char)c)) {
                            if ((s = IOFNMatchPrimitiveNode.rb_path_next(string, s, send)) < send) {
                                ++s;
                                continue block6;
                            }
                            return 1;
                        }
                        char test = (char)(escape && c == 92 && pat < pend ? bytes[pat] & 0xFF : c);
                        test = Character.toLowerCase(test);
                        --pat;
                        while (s < send) {
                            if ((c == 63 || c == 91 || Character.toLowerCase((char)string[s]) == test) && IOFNMatchPrimitiveNode.fnmatch(bytes, pat, pend, string, s, send, flags | 4) == 0) {
                                return 0;
                            }
                            if (pathname && IOFNMatchPrimitiveNode.isdirsep(string[s])) break;
                            ++s;
                        }
                        return 1;
                    }
                    case 91: {
                        if (s >= send || pathname && IOFNMatchPrimitiveNode.isdirsep(string[s]) || period && string[s] == 46 && (s == 0 || pathname && IOFNMatchPrimitiveNode.isdirsep(string[s - 1]))) {
                            return 1;
                        }
                        if ((pat = IOFNMatchPrimitiveNode.range(bytes, pat, pend, (char)(string[s] & 0xFF), flags)) == -1) {
                            return 1;
                        }
                        ++s;
                        continue block6;
                    }
                    case 92: {
                        if (!escape) break;
                        c = pat >= pend ? 92 : (char)(bytes[pat++] & 0xFF);
                    }
                }
                if (s >= send) {
                    return 1;
                }
                if (!(DOSISH && pathname && IOFNMatchPrimitiveNode.isdirsep((char)c) && IOFNMatchPrimitiveNode.isdirsep(string[s]) || !(nocase ? Character.toLowerCase((char)c) != Character.toLowerCase((char)string[s]) : c != (int)(string[s] & 0xFF)))) {
                    return 1;
                }
                ++s;
            }
            return s >= send ? 0 : 1;
        }

        public static int fnmatch(byte[] bytes, int pstart, int pend, byte[] string, int sstart, int send, int flags) {
            boolean period = (flags & 4) == 0;
            boolean pathname = (flags & 2) != 0;
            int pat_pos = pstart;
            int str_pos = sstart;
            int ptmp = -1;
            int stmp = -1;
            if (pathname) {
                while (true) {
                    int strSlashIdx;
                    int patSlashIdx;
                    if (IOFNMatchPrimitiveNode.isDoubleStarAndSlash(bytes, pat_pos)) {
                        while (IOFNMatchPrimitiveNode.isDoubleStarAndSlash(bytes, pat_pos += 3)) {
                        }
                        ptmp = pat_pos;
                        stmp = str_pos;
                    }
                    if (IOFNMatchPrimitiveNode.fnmatch_helper(bytes, pat_pos, patSlashIdx = IOFNMatchPrimitiveNode.nextSlashIndex(bytes, pat_pos, pend), string, str_pos, strSlashIdx = IOFNMatchPrimitiveNode.nextSlashIndex(string, str_pos, send), flags) == 0) {
                        if (patSlashIdx < pend && strSlashIdx < send) {
                            pat_pos = ++patSlashIdx;
                            str_pos = ++strSlashIdx;
                            continue;
                        }
                        if (patSlashIdx == pend && strSlashIdx == send) {
                            return 0;
                        }
                    }
                    if (ptmp == -1 || stmp == -1 || period && string[stmp] == 46 || (stmp = IOFNMatchPrimitiveNode.nextSlashIndex(string, stmp, send)) >= send) break;
                    pat_pos = ptmp;
                    str_pos = ++stmp;
                }
                return 1;
            }
            return IOFNMatchPrimitiveNode.fnmatch_helper(bytes, pstart, pend, string, sstart, send, flags);
        }

        private static boolean isDoubleStarAndSlash(byte[] bytes, int pos) {
            if (bytes.length - pos <= 2) {
                return false;
            }
            return bytes[pos] == 42 && bytes[pos + 1] == 42 && bytes[pos + 2] == 47;
        }

        private static int nextSlashIndex(byte[] bytes, int start, int end) {
            int idx;
            for (idx = start; idx < end && idx < bytes.length && bytes[idx] != 47; ++idx) {
            }
            return idx;
        }

        private static int range(byte[] _pat, int pat, int pend, char test, int flags) {
            boolean not;
            boolean ok = false;
            boolean nocase = (flags & 8) != 0;
            boolean escape = (flags & 1) == 0;
            boolean bl = not = _pat[pat] == 33 || _pat[pat] == 94;
            if (not) {
                ++pat;
            }
            if (nocase) {
                test = Character.toLowerCase(test);
            }
            while (_pat[pat] != 93) {
                char cend;
                if (escape && _pat[pat] == 92) {
                    ++pat;
                }
                if (pat >= pend) {
                    return -1;
                }
                char cstart = cend = (char)(_pat[pat++] & 0xFF);
                if (_pat[pat] == 45 && _pat[pat + 1] != 93) {
                    if (escape && _pat[++pat] == 92) {
                        ++pat;
                    }
                    if (pat >= pend) {
                        return -1;
                    }
                    cend = (char)(_pat[pat++] & 0xFF);
                }
                if (nocase) {
                    if (Character.toLowerCase(cstart) > test || test > Character.toLowerCase(cend)) continue;
                    ok = true;
                    continue;
                }
                if (cstart > test || test > cend) continue;
                ok = true;
            }
            return ok == not ? -1 : pat + 1;
        }
    }

    @Primitive(name="io_ftruncate", unsafe={UnsafeGroup.IO})
    public static abstract class IOFTruncatePrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @Specialization
        public int ftruncate(DynamicObject io, long length) {
            int fd = Layouts.IO.getDescriptor(io);
            return this.ensureSuccessful(this.posix().ftruncate(fd, length));
        }
    }

    @Primitive(name="io_truncate", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class IOTruncatePrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(path)"})
        public int truncate(DynamicObject path, long length) {
            return this.ensureSuccessful(this.posix().truncate(StringOperations.getString(path), length));
        }
    }

    @Primitive(name="io_open", needsSelf=false, lowerFixnum={2, 3}, unsafe={UnsafeGroup.IO})
    public static abstract class IOOpenPrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(path)"})
        public int open(DynamicObject path, int mode, int permission) {
            String pathString = StringOperations.getString(path);
            int fd = this.posix().open(pathString, mode, permission);
            if (fd == -1) {
                this.ensureSuccessful(fd, pathString);
            }
            return fd;
        }
    }

    @Primitive(name="io_connect_pipe", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class IOConnectPipeNode
    extends IOPrimitiveArrayArgumentsNode {
        @CompilerDirectives.CompilationFinal
        private int RDONLY = -1;
        @CompilerDirectives.CompilationFinal
        private int WRONLY = -1;

        @Specialization
        public boolean connectPipe(DynamicObject lhs, DynamicObject rhs) {
            int[] fds = new int[2];
            this.ensureSuccessful(this.posix().pipe(fds));
            this.newOpenFd(fds[0]);
            this.newOpenFd(fds[1]);
            Layouts.IO.setDescriptor(lhs, fds[0]);
            Layouts.IO.setMode(lhs, this.getRDONLY());
            Layouts.IO.setDescriptor(rhs, fds[1]);
            Layouts.IO.setMode(rhs, this.getWRONLY());
            return true;
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        private void newOpenFd(int newFd) {
            boolean FD_CLOEXEC = true;
            if (newFd > 2) {
                int flags = this.ensureSuccessful(this.posix().fcntl(newFd, Fcntl.F_GETFD));
                this.ensureSuccessful(this.posix().fcntlInt(newFd, Fcntl.F_SETFD, flags | 1));
            }
        }

        private int getRDONLY() {
            if (this.RDONLY == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.RDONLY = (Integer)this.getContext().getNativePlatform().getRubiniusConfiguration().get("rbx.platform.file.O_RDONLY");
            }
            return this.RDONLY;
        }

        private int getWRONLY() {
            if (this.WRONLY == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.WRONLY = (Integer)this.getContext().getNativePlatform().getRubiniusConfiguration().get("rbx.platform.file.O_WRONLY");
            }
            return this.WRONLY;
        }
    }

    @Primitive(name="io_allocate", unsafe={UnsafeGroup.IO})
    public static abstract class IOAllocatePrimitiveNode
    extends IOPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode newBufferNode = DispatchHeadNodeFactory.createMethodCall();
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocate(VirtualFrame frame, DynamicObject classToAllocate) {
            DynamicObject buffer = (DynamicObject)this.newBufferNode.call(frame, this.coreLibrary().getInternalBufferClass(), "new", new Object[0]);
            return this.allocateNode.allocate(classToAllocate, buffer, 0, 0, 0);
        }
    }

    public static abstract class IOPrimitiveArrayArgumentsNode
    extends PrimitiveArrayArgumentsNode {
        private final BranchProfile errorProfile = BranchProfile.create();

        protected int ensureSuccessful(int result, int errno, String extra) {
            assert (result >= -1);
            if (result == -1) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().errnoError(errno, extra, this));
            }
            return result;
        }

        protected int ensureSuccessful(int result) {
            return this.ensureSuccessful(result, this.posix().errno(), "");
        }

        protected int ensureSuccessful(int result, String extra) {
            return this.ensureSuccessful(result, this.posix().errno(), " - " + extra);
        }
    }
}

