/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.WarnNode;
import org.jruby.truffle.language.constants.LookupConstantInterface;
import org.jruby.truffle.language.constants.LookupConstantNodeGen;
import org.jruby.truffle.language.control.RaiseException;

@NodeChildren(value={@NodeChild(value="module", type=RubyNode.class), @NodeChild(value="name", type=RubyNode.class)})
public abstract class LookupConstantNode
extends RubyNode
implements LookupConstantInterface {
    private final boolean ignoreVisibility;
    private final boolean lookInObject;
    @Node.Child
    private WarnNode warnNode;

    public static LookupConstantNode create(boolean ignoreVisibility, boolean lookInObject) {
        return LookupConstantNodeGen.create(ignoreVisibility, lookInObject, null, null);
    }

    public LookupConstantNode(boolean ignoreVisibility, boolean lookInObject) {
        this.ignoreVisibility = ignoreVisibility;
        this.lookInObject = lookInObject;
    }

    public abstract RubyConstant executeLookupConstant(VirtualFrame var1, Object var2, String var3);

    @Override
    public RubyConstant lookupConstant(VirtualFrame frame, Object module, String name) {
        return this.executeLookupConstant(frame, module, name);
    }

    @Specialization(guards={"module == cachedModule", "isRubyModule(cachedModule)", "guardName(name, cachedName, sameNameProfile)"}, assumptions={"getUnmodifiedAssumption(cachedModule)"}, limit="getCacheLimit()")
    protected RubyConstant lookupConstant(VirtualFrame frame, DynamicObject module, String name, @Cached(value="module") DynamicObject cachedModule, @Cached(value="name") String cachedName, @Cached(value="doLookup(cachedModule, cachedName)") RubyConstant constant, @Cached(value="isVisible(cachedModule, constant)") boolean isVisible, @Cached(value="createBinaryProfile()") ConditionProfile sameNameProfile) {
        if (!isVisible) {
            throw new RaiseException(this.coreExceptions().nameErrorPrivateConstant(module, name, this));
        }
        if (constant != null && constant.isDeprecated()) {
            this.warnDeprecatedConstant(frame, name);
        }
        return constant;
    }

    private void warnDeprecatedConstant(VirtualFrame frame, String name) {
        if (this.warnNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.warnNode = this.insert(new WarnNode());
        }
        this.warnNode.execute(frame, "constant ", name, " is deprecated");
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    @Specialization(guards={"isRubyModule(module)"})
    protected RubyConstant lookupConstantUncached(VirtualFrame frame, DynamicObject module, String name, @Cached(value="createBinaryProfile()") ConditionProfile isVisibleProfile, @Cached(value="createBinaryProfile()") ConditionProfile isDeprecatedProfile) {
        RubyConstant constant = this.doLookup(module, name);
        boolean isVisible = this.isVisible(module, constant);
        if (isVisibleProfile.profile(!isVisible)) {
            throw new RaiseException(this.coreExceptions().nameErrorPrivateConstant(module, name, this));
        }
        if (isDeprecatedProfile.profile(constant != null && constant.isDeprecated())) {
            this.warnDeprecatedConstant(frame, name);
        }
        return constant;
    }

    @Specialization(guards={"!isRubyModule(module)"})
    protected RubyConstant lookupNotModule(Object module, String name) {
        throw new RaiseException(this.coreExceptions().typeErrorIsNotAClassModule(module, this));
    }

    protected boolean guardName(String name, String cachedName, ConditionProfile sameNameProfile) {
        if (sameNameProfile.profile(name == cachedName)) {
            return true;
        }
        return name.equals(cachedName);
    }

    @CompilerDirectives.TruffleBoundary
    protected RubyConstant doLookup(DynamicObject module, String name) {
        if (this.lookInObject) {
            return ModuleOperations.lookupConstantAndObject(this.getContext(), module, name);
        }
        return ModuleOperations.lookupConstant(this.getContext(), module, name);
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean isVisible(DynamicObject module, RubyConstant constant) {
        return this.ignoreVisibility || constant == null || constant.isVisibleTo(this.getContext(), LexicalScope.NONE, module);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().CONSTANT_CACHE;
    }
}

