/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.language.RubyNode;

public class OrNode
extends RubyNode {
    @Node.Child
    private RubyNode left;
    @Node.Child
    private RubyNode right;
    @Node.Child
    private BooleanCastNode leftCast;
    private final ConditionProfile conditionProfile = ConditionProfile.createCountingProfile();

    public OrNode(RubyNode left, RubyNode right) {
        this.left = left;
        this.right = right;
        this.leftCast = BooleanCastNodeGen.create(null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object leftValue = this.left.execute(frame);
        boolean leftBoolean = this.leftCast.executeToBoolean(leftValue);
        if (this.conditionProfile.profile(leftBoolean)) {
            return leftValue;
        }
        return this.right.execute(frame);
    }
}

