/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.truffle.options.OptionDescription;
import org.jruby.truffle.options.OptionTypeException;

public class StringArrayOptionDescription
extends OptionDescription {
    private final String[] defaultValue;

    public StringArrayOptionDescription(String name, String description, String[] defaultValue) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue.clone();
    }

    @Override
    public Object checkValue(Object value) {
        if (value instanceof String[]) {
            return value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            String[] strings = new String[collection.size()];
            int n = 0;
            for (Object item : collection) {
                strings[n] = item.toString();
                ++n;
            }
            return strings;
        }
        if (value instanceof String) {
            return this.parseStringArray((String)value);
        }
        throw new OptionTypeException(this.getName(), value.toString());
    }

    private String[] parseStringArray(String string) {
        ArrayList<String> values = new ArrayList<String>();
        boolean startOfString = false;
        boolean withinString = true;
        int escape = 2;
        int state = 0;
        StringBuilder builder = new StringBuilder();
        block13: for (int n = 0; n < string.length(); ++n) {
            switch (state) {
                case 0: {
                    builder.setLength(0);
                    builder.append(string.charAt(n));
                    state = 1;
                    continue block13;
                }
                case 1: {
                    switch (string.charAt(n)) {
                        case ',': {
                            values.add(builder.toString());
                            state = 0;
                            continue block13;
                        }
                        case '\\': {
                            state = 2;
                            continue block13;
                        }
                    }
                    builder.append(string.charAt(n));
                    continue block13;
                }
                case 2: {
                    if (string.charAt(n) != ',') {
                        throw new OptionTypeException(this.getName(), string);
                    }
                    state = 1;
                    builder.append(string.charAt(n));
                }
            }
        }
        switch (state) {
            case 1: {
                values.add(builder.toString());
                break;
            }
            case 2: {
                throw new OptionTypeException(this.getName(), string);
            }
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String toString(Object value) {
        return String.join((CharSequence)",", (String[])value);
    }
}

