/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ConnectionTool
extends AbstractTool {
    private Connector myStartConnector;
    private Connector myEndConnector;
    private Connector myTargetConnector;
    private Figure myTarget;
    private ConnectionFigure myConnection;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection;
    private Figure myAddedFigure;
    private ConnectionFigure fPrototype;

    public ConnectionTool(DrawingEditor newDrawingEditor, ConnectionFigure newPrototype) {
        super(newDrawingEditor);
        this.fPrototype = newPrototype;
    }

    public void mouseMove(MouseEvent e, int x, int y) {
        this.trackConnectors(e, x, y);
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        int ex = e.getX();
        int ey = e.getY();
        this.setTargetFigure(this.findConnectionStart(ex, ey, this.drawing()));
        if (this.getTargetFigure() != null) {
            this.setStartConnector(this.findConnector(ex, ey, this.getTargetFigure()));
            if (this.getStartConnector() != null) {
                Point p = new Point(ex, ey);
                this.setConnection(this.createConnection());
                this.getConnection().startPoint(p.x, p.y);
                this.getConnection().endPoint(p.x, p.y);
                this.setAddedFigure(this.view().add(this.getConnection()));
            }
        } else {
            ConnectionFigure connection = this.findConnection(ex, ey, this.drawing());
            if (connection != null) {
                if (!connection.joinSegments(ex, ey)) {
                    this.fSplitPoint = connection.splitSegment(ex, ey);
                    this.fEditedConnection = connection;
                } else {
                    this.fEditedConnection = null;
                }
            }
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        Point p = new Point(e.getX(), e.getY());
        if (this.getConnection() != null) {
            this.trackConnectors(e, x, y);
            if (this.getTargetConnector() != null) {
                p = Geom.center(this.getTargetConnector().displayBox());
            }
            this.getConnection().endPoint(p.x, p.y);
        } else if (this.fEditedConnection != null) {
            Point pp = new Point(x, y);
            this.fEditedConnection.setPointAt(pp, this.fSplitPoint);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        Figure c = null;
        if (this.getStartConnector() != null) {
            c = this.findTarget(e.getX(), e.getY(), this.drawing());
        }
        if (c != null) {
            this.setEndConnector(this.findConnector(e.getX(), e.getY(), c));
            if (this.getEndConnector() != null) {
                this.getConnection().connectStart(this.getStartConnector());
                this.getConnection().connectEnd(this.getEndConnector());
                this.getConnection().updateConnection();
                this.setUndoActivity(this.createUndoActivity());
                this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.getAddedFigure()));
            }
        } else if (this.getConnection() != null) {
            this.view().remove(this.getConnection());
        }
        this.setConnection(null);
        this.setStartConnector(null);
        this.setEndConnector(null);
        this.setAddedFigure(null);
        this.editor().toolDone();
    }

    public void deactivate() {
        super.deactivate();
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().connectorVisibility(false);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Figure findSource(int x, int y, Drawing drawing) {
        return this.findConnectableFigure(x, y, drawing);
    }

    protected Figure findTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        Figure start = this.getStartConnector().owner();
        if (target != null && this.getConnection() != null && target.canConnect() && !target.includes(start) && this.getConnection().canConnect(start, target)) {
            return target;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = (Figure)k.nextElement();
            if ((figure = figure.findFigureInside(x, y)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    private void setConnection(ConnectionFigure newConnection) {
        this.myConnection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.myConnection;
    }

    protected void trackConnectors(MouseEvent e, int x, int y) {
        Figure c = null;
        c = this.getStartConnector() == null ? this.findSource(x, y, this.drawing()) : this.findTarget(x, y, this.drawing());
        if (c != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(false);
            }
            this.setTargetFigure(c);
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().connectorVisibility(true);
            }
        }
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(e.getX(), e.getY(), c);
        }
        if (cc != this.getTargetConnector()) {
            this.setTargetConnector(cc);
        }
        this.view().checkDamage();
    }

    private Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect()) {
            return target;
        }
        return null;
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.getConnection()) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    private void setStartConnector(Connector newStartConnector) {
        this.myStartConnector = newStartConnector;
    }

    protected Connector getStartConnector() {
        return this.myStartConnector;
    }

    private void setEndConnector(Connector newEndConnector) {
        this.myEndConnector = newEndConnector;
    }

    protected Connector getEndConnector() {
        return this.myEndConnector;
    }

    private void setTargetConnector(Connector newTargetConnector) {
        this.myTargetConnector = newTargetConnector;
    }

    protected Connector getTargetConnector() {
        return this.myTargetConnector;
    }

    private void setTargetFigure(Figure newTarget) {
        this.myTarget = newTarget;
    }

    protected Figure getTargetFigure() {
        return this.myTarget;
    }

    protected Figure getAddedFigure() {
        return this.myAddedFigure;
    }

    private void setAddedFigure(Figure newAddedFigure) {
        this.myAddedFigure = newAddedFigure;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.getConnection());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        private ConnectionFigure myConnection;
        private Connector myStartConnector;
        private Connector myEndConnector;

        public UndoActivity(DrawingView newDrawingView, ConnectionFigure newConnection) {
            super(newDrawingView);
            this.setConnection(newConnection);
            this.myStartConnector = this.getConnection().getStartConnector();
            this.myEndConnector = this.getConnection().getEndConnector();
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getConnection().disconnectStart();
            this.getConnection().disconnectEnd();
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                this.getDrawingView().drawing().orphan(fe.nextFigure());
            }
            this.getDrawingView().clearSelection();
            return true;
        }

        public boolean redo() {
            if (!super.redo()) {
                return false;
            }
            this.getConnection().connectStart(this.myStartConnector);
            this.getConnection().connectEnd(this.myEndConnector);
            this.getConnection().updateConnection();
            this.getDrawingView().insertFigures(this.getAffectedFigures(), 0, 0, false);
            return true;
        }

        private void setConnection(ConnectionFigure newConnection) {
            this.myConnection = newConnection;
        }

        protected ConnectionFigure getConnection() {
            return this.myConnection;
        }
    }
}

