/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Bits;

public abstract class LongValuesSource {
    public abstract LongValues getValues(LeafReaderContext var1, DoubleValues var2) throws IOException;

    public abstract boolean needsScores();

    public SortField getSortField(boolean reverse) {
        return new LongValuesSortField(this, reverse);
    }

    public static LongValuesSource fromLongField(String field) {
        return new FieldValuesSource(field);
    }

    public static LongValuesSource fromIntField(String field) {
        return LongValuesSource.fromLongField(field);
    }

    public static LongValuesSource constant(final long value) {
        return new LongValuesSource(){

            @Override
            public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
                return new LongValues(){

                    @Override
                    public long longValue() throws IOException {
                        return value;
                    }

                    @Override
                    public boolean advanceExact(int doc) throws IOException {
                        return true;
                    }
                };
            }

            @Override
            public boolean needsScores() {
                return false;
            }
        };
    }

    private static LongValues toLongValues(final NumericDocValues in, final Bits matchingBits) {
        return new LongValues(){
            int current = -1;

            @Override
            public long longValue() throws IOException {
                return in.get(this.current);
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.current = target;
                return matchingBits.get(target);
            }
        };
    }

    private static NumericDocValues asNumericDocValues(final LongValuesHolder in, final Long missingValue) {
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                try {
                    if (in.values.advanceExact(docID)) {
                        return in.values.longValue();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return missingValue;
            }
        };
    }

    private static class LongValuesComparatorSource
    extends FieldComparatorSource {
        private final LongValuesSource producer;

        public LongValuesComparatorSource(LongValuesSource producer) {
            this.producer = producer;
        }

        public FieldComparator<Long> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new FieldComparator.LongComparator(numHits, fieldname, 0L){
                LeafReaderContext ctx;
                LongValuesHolder holder;
                {
                    super(numHits, field, missingValue);
                    this.holder = new LongValuesHolder();
                }

                @Override
                protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                    this.ctx = context;
                    return LongValuesSource.asNumericDocValues(this.holder, (Long)this.missingValue);
                }

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.holder.values = producer.getValues(this.ctx, DoubleValuesSource.fromScorer(scorer));
                }
            };
        }
    }

    private static class LongValuesHolder {
        LongValues values;

        private LongValuesHolder() {
        }
    }

    private static class LongValuesSortField
    extends SortField {
        final LongValuesSource producer;

        public LongValuesSortField(LongValuesSource producer, boolean reverse) {
            super(producer.toString(), new LongValuesComparatorSource(producer), reverse);
            this.producer = producer;
        }

        @Override
        public boolean needsScores() {
            return this.producer.needsScores();
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder("<");
            buffer.append(this.getField()).append(">");
            if (this.reverse) {
                buffer.append("!");
            }
            return buffer.toString();
        }
    }

    private static class FieldValuesSource
    extends LongValuesSource {
        final String field;

        private FieldValuesSource(String field) {
            this.field = field;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldValuesSource that = (FieldValuesSource)o;
            return Objects.equals(this.field, that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field);
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            NumericDocValues values = DocValues.getNumeric(ctx.reader(), this.field);
            Bits matchingBits = DocValues.getDocsWithField(ctx.reader(), this.field);
            return LongValuesSource.toLongValues(values, matchingBits);
        }

        @Override
        public boolean needsScores() {
            return false;
        }
    }
}

