/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;

public class PutStoredScriptRequest
extends AcknowledgedRequest<PutStoredScriptRequest> {
    private String id;
    private String scriptLang;
    private BytesReference script;

    public PutStoredScriptRequest() {
    }

    public PutStoredScriptRequest(String scriptLang) {
        this.scriptLang = scriptLang;
    }

    public PutStoredScriptRequest(String scriptLang, String id) {
        this.scriptLang = scriptLang;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError("id can't contain: '#'", validationException);
        }
        if (this.scriptLang == null) {
            validationException = ValidateActions.addValidationError("lang is missing", validationException);
        } else if (this.scriptLang.contains("#")) {
            validationException = ValidateActions.addValidationError("lang can't contain: '#'", validationException);
        }
        if (this.script == null) {
            validationException = ValidateActions.addValidationError("script is missing", validationException);
        }
        return validationException;
    }

    public String scriptLang() {
        return this.scriptLang;
    }

    public PutStoredScriptRequest scriptLang(String scriptLang) {
        this.scriptLang = scriptLang;
        return this;
    }

    public String id() {
        return this.id;
    }

    public PutStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public BytesReference script() {
        return this.script;
    }

    public PutStoredScriptRequest script(BytesReference source) {
        this.script = source;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.scriptLang = in.readString();
        this.id = in.readOptionalString();
        this.script = in.readBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.scriptLang);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.script);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.script, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "put script {[" + this.id + "][" + this.scriptLang + "], script[" + sSource + "]}";
    }
}

