/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;

class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    final AtomicArray<QuerySearchResult> queryResults;
    final AtomicArray<FetchSearchResult> fetchResults;
    final AtomicArray<IntArrayList> docIdsToLoad;
    private final SearchPhaseController searchPhaseController;

    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, Function<String, DiscoveryNode> nodeIdToDiscoveryNode, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator shardsIts, long startTime, long clusterStateVersion, SearchTask task) {
        super(logger, searchTransportService, nodeIdToDiscoveryNode, aliasFilter, concreteIndexBoosts, executor, request, listener, shardsIts, startTime, clusterStateVersion, task);
        this.searchPhaseController = searchPhaseController;
        this.queryResults = new AtomicArray(this.firstResults.length());
        this.fetchResults = new AtomicArray(this.firstResults.length());
        this.docIdsToLoad = new AtomicArray(this.firstResults.length());
    }

    @Override
    protected String firstPhaseName() {
        return "dfs";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<DfsSearchResult> listener) {
        this.searchTransportService.sendExecuteDfs(node, request, this.task, listener);
    }

    @Override
    protected void moveToSecondPhase() {
        AggregatedDfs dfs = this.searchPhaseController.aggregateDfs(this.firstResults);
        AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
        for (AtomicArray.Entry entry : this.firstResults.asList()) {
            DfsSearchResult dfsResult = (DfsSearchResult)entry.value;
            DiscoveryNode node = (DiscoveryNode)this.nodeIdToDiscoveryNode.apply(dfsResult.shardTarget().nodeId());
            QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
            this.executeQuery(entry.index, dfsResult, counter, querySearchRequest, node);
        }
    }

    void executeQuery(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, final QuerySearchRequest querySearchRequest, final DiscoveryNode node) {
        this.searchTransportService.sendExecuteQuery(node, querySearchRequest, this.task, new ActionListener<QuerySearchResult>(){

            @Override
            public void onResponse(QuerySearchResult result) {
                result.shardTarget(dfsResult.shardTarget());
                SearchDfsQueryThenFetchAsyncAction.this.queryResults.set(shardIndex, result);
                if (counter.decrementAndGet() == 0) {
                    SearchDfsQueryThenFetchAsyncAction.this.executeFetchPhase();
                }
            }

            @Override
            public void onFailure(Exception t) {
                try {
                    SearchDfsQueryThenFetchAsyncAction.this.onQueryFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                }
                finally {
                    SearchDfsQueryThenFetchAsyncAction.this.sendReleaseSearchContext(querySearchRequest.id(), node);
                }
            }
        });
    }

    void onQueryFailure(Exception e, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)querySearchRequest.id()), (Throwable)e);
        }
        this.addShardFailure(shardIndex, dfsResult.shardTarget(), e);
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            if (this.successfulOps.get() == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "all shards failed", this.buildShardFailures()));
            } else {
                this.executeFetchPhase();
            }
        }
    }

    void executeFetchPhase() {
        try {
            this.innerExecuteFetchPhase();
        }
        catch (Exception e) {
            this.listener.onFailure(new ReduceSearchPhaseException("query", "", e, this.buildShardFailures()));
        }
    }

    void innerExecuteFetchPhase() throws Exception {
        boolean isScrollRequest = this.request.scroll() != null;
        this.sortedShardDocs = this.searchPhaseController.sortDocs(isScrollRequest, this.queryResults);
        this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardDocs);
        if (this.docIdsToLoad.asList().isEmpty()) {
            this.finishHim();
            return;
        }
        ScoreDoc[] lastEmittedDocPerShard = this.request.scroll() != null ? this.searchPhaseController.getLastEmittedDocPerShard(this.queryResults.asList(), this.sortedShardDocs, this.firstResults.length()) : null;
        AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
        for (AtomicArray.Entry<IntArrayList> entry : this.docIdsToLoad.asList()) {
            QuerySearchResult queryResult = this.queryResults.get(entry.index);
            DiscoveryNode node = (DiscoveryNode)this.nodeIdToDiscoveryNode.apply(queryResult.shardTarget().nodeId());
            ShardFetchSearchRequest fetchSearchRequest = this.createFetchRequest(queryResult, entry, lastEmittedDocPerShard);
            this.executeFetch(entry.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
        }
    }

    void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final ShardFetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
        this.searchTransportService.sendExecuteFetch(node, fetchSearchRequest, this.task, new ActionListener<FetchSearchResult>(){

            @Override
            public void onResponse(FetchSearchResult result) {
                result.shardTarget(shardTarget);
                SearchDfsQueryThenFetchAsyncAction.this.fetchResults.set(shardIndex, result);
                if (counter.decrementAndGet() == 0) {
                    SearchDfsQueryThenFetchAsyncAction.this.finishHim();
                }
            }

            @Override
            public void onFailure(Exception t) {
                SearchDfsQueryThenFetchAsyncAction.this.docIdsToLoad.set(shardIndex, null);
                SearchDfsQueryThenFetchAsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
            }
        });
    }

    void onFetchFailure(Exception e, ShardFetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute fetch phase", (Object)fetchSearchRequest.id()), (Throwable)e);
        }
        this.addShardFailure(shardIndex, shardTarget, e);
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            this.finishHim();
        }
    }

    private void finishHim() {
        this.getExecutor().execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                boolean isScrollRequest = SearchDfsQueryThenFetchAsyncAction.this.request.scroll() != null;
                InternalSearchResponse internalResponse = SearchDfsQueryThenFetchAsyncAction.this.searchPhaseController.merge(isScrollRequest, SearchDfsQueryThenFetchAsyncAction.this.sortedShardDocs, SearchDfsQueryThenFetchAsyncAction.this.queryResults, SearchDfsQueryThenFetchAsyncAction.this.fetchResults);
                String scrollId = isScrollRequest ? TransportSearchHelper.buildScrollId(SearchDfsQueryThenFetchAsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)SearchDfsQueryThenFetchAsyncAction.this.firstResults) : null;
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, SearchDfsQueryThenFetchAsyncAction.this.expectedSuccessfulOps, SearchDfsQueryThenFetchAsyncAction.this.successfulOps.get(), SearchDfsQueryThenFetchAsyncAction.this.buildTookInMillis(), SearchDfsQueryThenFetchAsyncAction.this.buildShardFailures()));
                SearchDfsQueryThenFetchAsyncAction.this.releaseIrrelevantSearchContexts(SearchDfsQueryThenFetchAsyncAction.this.queryResults, SearchDfsQueryThenFetchAsyncAction.this.docIdsToLoad);
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    ReduceSearchPhaseException failure = new ReduceSearchPhaseException("merge", "", e, SearchDfsQueryThenFetchAsyncAction.this.buildShardFailures());
                    if (SearchDfsQueryThenFetchAsyncAction.this.logger.isDebugEnabled()) {
                        SearchDfsQueryThenFetchAsyncAction.this.logger.debug("failed to reduce search", (Throwable)failure);
                    }
                    super.onFailure(failure);
                }
                finally {
                    SearchDfsQueryThenFetchAsyncAction.this.releaseIrrelevantSearchContexts(SearchDfsQueryThenFetchAsyncAction.this.queryResults, SearchDfsQueryThenFetchAsyncAction.this.docIdsToLoad);
                }
            }
        });
    }
}

