/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchDfsQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchDfsQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchQueryAndFetchAsyncAction;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    public static final Setting<Long> SHARD_COUNT_LIMIT_SETTING = Setting.longSetting("action.search.shard_count.limit", 1000L, 1L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final SearchPhaseController searchPhaseController;
    private final SearchService searchService;

    @Inject
    public TransportSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, SearchService searchService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/search", threadPool, transportService, actionFilters, indexNameExpressionResolver, SearchRequest::new);
        this.searchPhaseController = searchPhaseController;
        this.searchTransportService = searchTransportService;
        SearchTransportService.registerRequestHandler(transportService, searchService);
        this.clusterService = clusterService;
        this.searchService = searchService;
    }

    private Map<String, AliasFilter> buildPerIndexAliasFilter(SearchRequest request, ClusterState clusterState, Index[] concreteIndices) {
        HashMap<String, AliasFilter> aliasFilterMap = new HashMap<String, AliasFilter>();
        for (Index index : concreteIndices) {
            clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index.getName());
            AliasFilter aliasFilter = this.searchService.buildAliasFilter(clusterState, index.getName(), request.indices());
            assert (aliasFilter != null);
            aliasFilterMap.put(index.getUUID(), aliasFilter);
        }
        return aliasFilterMap;
    }

    private Map<String, Float> resolveIndexBoosts(SearchRequest searchRequest, ClusterState clusterState) {
        if (searchRequest.source() == null) {
            return Collections.emptyMap();
        }
        SearchSourceBuilder source = searchRequest.source();
        if (source.indexBoosts() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Float> concreteIndexBoosts = new HashMap<String, Float>();
        for (SearchSourceBuilder.IndexBoost ib : source.indexBoosts()) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest.indicesOptions(), ib.getIndex())) {
                concreteIndexBoosts.putIfAbsent(concreteIndex.getUUID(), Float.valueOf(ib.getBoost()));
            }
        }
        return Collections.unmodifiableMap(concreteIndexBoosts);
    }

    @Override
    protected void doExecute(Task task, SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        long startTimeInMillis = Math.max(0L, System.currentTimeMillis());
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        Index[] indices = this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest.indicesOptions(), startTimeInMillis, searchRequest.indices());
        Map<String, AliasFilter> aliasFilter = this.buildPerIndexAliasFilter(searchRequest, clusterState, indices);
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(clusterState, searchRequest.routing(), searchRequest.indices());
        String[] concreteIndices = new String[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            concreteIndices[i] = indices[i].getName();
        }
        GroupShardsIterator shardIterators = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, searchRequest.preference());
        this.failIfOverShardCountLimit(this.clusterService, shardIterators.size());
        Map<String, Float> concreteIndexBoosts = this.resolveIndexBoosts(searchRequest, clusterState);
        if (shardIterators.size() == 1) {
            searchRequest.searchType(SearchType.QUERY_AND_FETCH);
        }
        if (searchRequest.isSuggestOnly()) {
            searchRequest.requestCache(false);
            switch (searchRequest.searchType()) {
                case DFS_QUERY_AND_FETCH: 
                case DFS_QUERY_THEN_FETCH: {
                    searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
                }
            }
        }
        this.searchAsyncAction((SearchTask)task, searchRequest, shardIterators, startTimeInMillis, clusterState, Collections.unmodifiableMap(aliasFilter), concreteIndexBoosts, listener).start();
    }

    @Override
    protected final void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        throw new UnsupportedOperationException("the task parameter is required");
    }

    private AbstractSearchAsyncAction searchAsyncAction(SearchTask task, SearchRequest searchRequest, GroupShardsIterator shardIterators, long startTime, ClusterState state, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, ActionListener<SearchResponse> listener) {
        AbstractSearchAsyncAction searchAsyncAction;
        Function<String, DiscoveryNode> nodesLookup = state.nodes()::get;
        long clusterStateVersion = state.version();
        ExecutorService executor = this.threadPool.executor("search");
        switch (searchRequest.searchType()) {
            case DFS_QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchDfsQueryThenFetchAsyncAction(this.logger, this.searchTransportService, nodesLookup, aliasFilter, concreteIndexBoosts, this.searchPhaseController, executor, searchRequest, listener, shardIterators, startTime, clusterStateVersion, task);
                break;
            }
            case QUERY_THEN_FETCH: {
                searchAsyncAction = new SearchQueryThenFetchAsyncAction(this.logger, this.searchTransportService, nodesLookup, aliasFilter, concreteIndexBoosts, this.searchPhaseController, executor, searchRequest, listener, shardIterators, startTime, clusterStateVersion, task);
                break;
            }
            case DFS_QUERY_AND_FETCH: {
                searchAsyncAction = new SearchDfsQueryAndFetchAsyncAction(this.logger, this.searchTransportService, nodesLookup, aliasFilter, concreteIndexBoosts, this.searchPhaseController, executor, searchRequest, listener, shardIterators, startTime, clusterStateVersion, task);
                break;
            }
            case QUERY_AND_FETCH: {
                searchAsyncAction = new SearchQueryAndFetchAsyncAction(this.logger, this.searchTransportService, nodesLookup, aliasFilter, concreteIndexBoosts, this.searchPhaseController, executor, searchRequest, listener, shardIterators, startTime, clusterStateVersion, task);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown search type: [" + (Object)((Object)searchRequest.searchType()) + "]");
            }
        }
        return searchAsyncAction;
    }

    private void failIfOverShardCountLimit(ClusterService clusterService, int shardCount) {
        long shardCountLimit = clusterService.getClusterSettings().get(SHARD_COUNT_LIMIT_SETTING);
        if ((long)shardCount > shardCountLimit) {
            throw new IllegalArgumentException("Trying to query " + shardCount + " shards, which is over the limit of " + shardCountLimit + ". This limit exists because querying many shards at the same time can make the job of the coordinating node very CPU and/or memory intensive. It is usually a better idea to have a smaller number of larger shards. Update [" + SHARD_COUNT_LIMIT_SETTING.getKey() + "] to a greater value if you really want to query that many shards at the same time.");
        }
    }
}

