/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public abstract class TransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends AbstractComponent {
    protected final ThreadPool threadPool;
    protected final String actionName;
    private final ActionFilter[] filters;
    protected final ParseFieldMatcher parseFieldMatcher;
    protected final IndexNameExpressionResolver indexNameExpressionResolver;
    protected final TaskManager taskManager;

    protected TransportAction(Settings settings, String actionName, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TaskManager taskManager) {
        super(settings);
        this.threadPool = threadPool;
        this.actionName = actionName;
        this.filters = actionFilters.filters();
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.taskManager = taskManager;
    }

    public final ActionFuture<Response> execute(Request request) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        this.execute(request, future);
        return future;
    }

    public final Task execute(Request request, final ActionListener<Response> listener) {
        final Task task = this.taskManager.register("transport", this.actionName, (TransportRequest)request);
        if (task == null) {
            this.execute(null, request, listener);
        } else {
            this.execute(task, request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    TransportAction.this.taskManager.unregister(task);
                    listener.onResponse(response);
                }

                @Override
                public void onFailure(Exception e) {
                    TransportAction.this.taskManager.unregister(task);
                    listener.onFailure(e);
                }
            });
        }
        return task;
    }

    public final Task execute(Request request, final TaskListener<Response> listener) {
        final Task task = this.taskManager.register("transport", this.actionName, (TransportRequest)request);
        this.execute(task, request, new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                if (task != null) {
                    TransportAction.this.taskManager.unregister(task);
                }
                listener.onResponse(task, response);
            }

            @Override
            public void onFailure(Exception e) {
                if (task != null) {
                    TransportAction.this.taskManager.unregister(task);
                }
                listener.onFailure(task, e);
            }
        });
        return task;
    }

    public final void execute(Task task, Request request, ActionListener<Response> listener) {
        ActionRequestValidationException validationException = ((ActionRequest)request).validate();
        if (validationException != null) {
            listener.onFailure(validationException);
            return;
        }
        if (task != null && ((ActionRequest)request).getShouldStoreResult()) {
            listener = new TaskResultStoringActionListener(this.taskManager, task, listener);
        }
        RequestFilterChain<Request, Response> requestFilterChain = new RequestFilterChain<Request, Response>(this, this.logger);
        requestFilterChain.proceed(task, this.actionName, request, listener);
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        this.doExecute(request, listener);
    }

    protected abstract void doExecute(Request var1, ActionListener<Response> var2);

    private static class TaskResultStoringActionListener<Response extends ActionResponse>
    implements ActionListener<Response> {
        private final ActionListener<Response> delegate;
        private final Task task;
        private final TaskManager taskManager;

        private TaskResultStoringActionListener(TaskManager taskManager, Task task, ActionListener<Response> delegate) {
            this.taskManager = taskManager;
            this.task = task;
            this.delegate = delegate;
        }

        @Override
        public void onResponse(Response response) {
            try {
                this.taskManager.storeResult(this.task, response, this.delegate);
            }
            catch (Exception e) {
                this.delegate.onFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.taskManager.storeResult(this.task, e, this.delegate);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                this.delegate.onFailure(inner);
            }
        }
    }

    private static class RequestFilterChain<Request extends ActionRequest, Response extends ActionResponse>
    implements ActionFilterChain<Request, Response> {
        private final TransportAction<Request, Response> action;
        private final AtomicInteger index = new AtomicInteger();
        private final Logger logger;

        private RequestFilterChain(TransportAction<Request, Response> action, Logger logger) {
            this.action = action;
            this.logger = logger;
        }

        @Override
        public void proceed(Task task, String actionName, Request request, ActionListener<Response> listener) {
            int i = this.index.getAndIncrement();
            try {
                if (i < ((TransportAction)this.action).filters.length) {
                    ((TransportAction)this.action).filters[i].apply(task, actionName, request, listener, this);
                } else if (i == ((TransportAction)this.action).filters.length) {
                    this.action.doExecute(task, request, listener);
                } else {
                    listener.onFailure(new IllegalStateException("proceed was called too many times"));
                }
            }
            catch (Exception e) {
                this.logger.trace("Error during transport action execution.", (Throwable)e);
                listener.onFailure(e);
            }
        }
    }
}

