/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class MetaDataCreateIndexService
extends AbstractComponent {
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final AliasValidator aliasValidator;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final NamedXContentRegistry xContentRegistry;
    private final ThreadPool threadPool;

    @Inject
    public MetaDataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, AliasValidator aliasValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, NamedXContentRegistry xContentRegistry) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.aliasValidator = aliasValidator;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(settings, clusterService, threadPool);
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
    }

    public static void validateIndexName(String index, ClusterState state) {
        MetaDataCreateIndexService.validateIndexOrAliasName(index, InvalidIndexNameException::new);
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(index, "must be lowercase");
        }
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metaData().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(index).getIndex());
        }
        if (state.metaData().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public static void validateIndexOrAliasName(String index, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName(index)) {
            throw exceptionCtor.apply(index, "must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        if (index.contains("#")) {
            throw exceptionCtor.apply(index, "must not contain '#'");
        }
        if (index.charAt(0) == '_' || index.charAt(0) == '-' || index.charAt(0) == '+') {
            throw exceptionCtor.apply(index, "must not start with '_', '-', or '+'");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new ElasticsearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw exceptionCtor.apply(index, "index name is too long, (" + byteCount + " > " + 255 + ")");
        }
        if (index.equals(".") || index.equals("..")) {
            throw exceptionCtor.apply(index, "must not be '.' or '..'");
        }
    }

    public void createIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        this.onlyCreateIndex(request, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(request.index(), request.waitForActiveShards(), request.ackTimeout(), shardsAcked -> {
                    if (!shardsAcked.booleanValue()) {
                        this.logger.debug("[{}] index created, but the operation timed out while waiting for enough shards to be started.", (Object)request.index());
                    }
                    listener.onResponse(new CreateIndexClusterStateUpdateResponse(response.isAcknowledged(), (boolean)shardsAcked));
                }, listener::onFailure);
            } else {
                listener.onResponse(new CreateIndexClusterStateUpdateResponse(false, false));
            }
        }, listener::onFailure));
    }

    private void onlyCreateIndex(final CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        updatedSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        this.indexScopedSettings.validate(updatedSettingsBuilder);
        request.settings(updatedSettingsBuilder.build());
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, this.wrapPreservingContext(listener)){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Index createdIndex = null;
                String removalExtraInfo = null;
                IndicesClusterStateService.AllocatedIndices.IndexRemovalReason removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.FAILURE;
                try {
                    IndexMetaData indexMetaData;
                    void var11_17;
                    MetaDataCreateIndexService.this.validate(request, currentState);
                    for (Alias alias : request.aliases()) {
                        MetaDataCreateIndexService.this.aliasValidator.validateAlias(alias, request.index(), currentState.metaData());
                    }
                    List templates = MetaDataCreateIndexService.this.findTemplates(request, currentState);
                    HashMap<String, Object> customs = new HashMap<String, Object>();
                    HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
                    HashMap<String, AliasMetaData> templatesAliases = new HashMap<String, AliasMetaData>();
                    ArrayList<String> templateNames = new ArrayList<String>();
                    for (Map.Entry<String, String> entry : request.mappings().entrySet()) {
                        mappings.put(entry.getKey(), MapperService.parseMapping(MetaDataCreateIndexService.this.xContentRegistry, entry.getValue()));
                    }
                    for (Map.Entry<String, Object> entry : request.customs().entrySet()) {
                        customs.put(entry.getKey(), entry.getValue());
                    }
                    for (IndexTemplateMetaData indexTemplateMetaData : templates) {
                        templateNames.add(indexTemplateMetaData.getName());
                        for (ObjectObjectCursor<String, CompressedXContent> objectObjectCursor : indexTemplateMetaData.mappings()) {
                            if (mappings.containsKey(objectObjectCursor.key)) {
                                XContentHelper.mergeDefaults((Map)mappings.get(objectObjectCursor.key), MapperService.parseMapping(MetaDataCreateIndexService.this.xContentRegistry, ((CompressedXContent)objectObjectCursor.value).string()));
                                continue;
                            }
                            mappings.put((String)objectObjectCursor.key, MapperService.parseMapping(MetaDataCreateIndexService.this.xContentRegistry, ((CompressedXContent)objectObjectCursor.value).string()));
                        }
                        for (ObjectObjectCursor objectObjectCursor : indexTemplateMetaData.customs()) {
                            String type = (String)objectObjectCursor.key;
                            IndexMetaData.Custom custom = (IndexMetaData.Custom)objectObjectCursor.value;
                            IndexMetaData.Custom existing = (IndexMetaData.Custom)customs.get(type);
                            if (existing == null) {
                                customs.put(type, custom);
                                continue;
                            }
                            IndexMetaData.Custom merged = existing.mergeWith(custom);
                            customs.put(type, merged);
                        }
                        for (ObjectObjectCursor objectObjectCursor : indexTemplateMetaData.aliases()) {
                            AliasMetaData aliasMetaData = (AliasMetaData)objectObjectCursor.value;
                            if (request.aliases().contains(new Alias(aliasMetaData.alias())) || templatesAliases.containsKey(objectObjectCursor.key)) continue;
                            if (aliasMetaData.alias().contains("{index}")) {
                                String templatedAlias = aliasMetaData.alias().replace("{index}", request.index());
                                aliasMetaData = AliasMetaData.newAliasMetaData(aliasMetaData, templatedAlias);
                            }
                            MetaDataCreateIndexService.this.aliasValidator.validateAliasMetaData(aliasMetaData, request.index(), currentState.metaData());
                            templatesAliases.put(aliasMetaData.alias(), aliasMetaData);
                        }
                    }
                    Settings.Builder indexSettingsBuilder = Settings.builder();
                    int n = templates.size() - 1;
                    while (var11_17 >= 0) {
                        indexSettingsBuilder.put(((IndexTemplateMetaData)templates.get((int)var11_17)).settings());
                        --var11_17;
                    }
                    indexSettingsBuilder.put(request.settings());
                    if (indexSettingsBuilder.get("index.number_of_shards") == null) {
                        indexSettingsBuilder.put("index.number_of_shards", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_shards", 5));
                    }
                    if (indexSettingsBuilder.get("index.number_of_replicas") == null) {
                        indexSettingsBuilder.put("index.number_of_replicas", MetaDataCreateIndexService.this.settings.getAsInt("index.number_of_replicas", 1));
                    }
                    if (MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas") != null && indexSettingsBuilder.get("index.auto_expand_replicas") == null) {
                        indexSettingsBuilder.put("index.auto_expand_replicas", MetaDataCreateIndexService.this.settings.get("index.auto_expand_replicas"));
                    }
                    if (indexSettingsBuilder.get("index.version.created") == null) {
                        DiscoveryNodes discoveryNodes = currentState.nodes();
                        Version createdVersion = Version.min(Version.CURRENT, discoveryNodes.getSmallestNonClientNodeVersion());
                        indexSettingsBuilder.put("index.version.created", createdVersion);
                    }
                    if (indexSettingsBuilder.get("index.creation_date") == null) {
                        indexSettingsBuilder.put("index.creation_date", new DateTime(DateTimeZone.UTC).getMillis());
                    }
                    indexSettingsBuilder.put("index.provided_name", request.getProvidedName());
                    indexSettingsBuilder.put("index.uuid", UUIDs.randomBase64UUID());
                    Index index = request.shrinkFrom();
                    int routingNumShards = IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(indexSettingsBuilder.build());
                    if (index != null) {
                        MetaDataCreateIndexService.prepareShrinkIndexSettings(currentState, mappings.keySet(), indexSettingsBuilder, index, request.index());
                        IndexMetaData indexMetaData2 = currentState.metaData().getIndexSafe(index);
                        routingNumShards = indexMetaData2.getRoutingNumShards();
                    }
                    Settings settings = indexSettingsBuilder.build();
                    IndexMetaData.Builder tmpImdBuilder = IndexMetaData.builder(request.index()).setRoutingNumShards(routingNumShards);
                    IndexMetaData tmpImd = tmpImdBuilder.settings(settings).build();
                    ActiveShardCount waitForActiveShards = request.waitForActiveShards();
                    if (waitForActiveShards == ActiveShardCount.DEFAULT) {
                        waitForActiveShards = tmpImd.getWaitForActiveShards();
                    }
                    if (!waitForActiveShards.validate(tmpImd.getNumberOfReplicas())) {
                        throw new IllegalArgumentException("invalid wait_for_active_shards[" + request.waitForActiveShards() + "]: cannot be greater than number of shard copies [" + (tmpImd.getNumberOfReplicas() + 1) + "]");
                    }
                    IndicesClusterStateService.AllocatedIndex indexService = MetaDataCreateIndexService.this.indicesService.createIndex(tmpImd, Collections.emptyList());
                    createdIndex = ((AbstractIndexComponent)((Object)indexService)).index();
                    MapperService mapperService = ((IndexService)indexService).mapperService();
                    try {
                        mapperService.merge(mappings, MapperService.MergeReason.MAPPING_UPDATE, request.updateAllTypes());
                    }
                    catch (Exception e) {
                        removalExtraInfo = "failed on parsing default mapping/mappings on index creation";
                        throw e;
                    }
                    QueryShardContext queryShardContext = ((IndexService)indexService).newQueryShardContext(0, null, () -> 0L);
                    for (Alias alias : request.aliases()) {
                        if (!Strings.hasLength(alias.filter())) continue;
                        MetaDataCreateIndexService.this.aliasValidator.validateAliasFilter(alias.name(), alias.filter(), queryShardContext, MetaDataCreateIndexService.this.xContentRegistry);
                    }
                    for (Object aliasMetaData : templatesAliases.values()) {
                        if (((AliasMetaData)aliasMetaData).filter() == null) continue;
                        MetaDataCreateIndexService.this.aliasValidator.validateAliasFilter(((AliasMetaData)aliasMetaData).alias(), ((AliasMetaData)aliasMetaData).filter().uncompressed(), queryShardContext, MetaDataCreateIndexService.this.xContentRegistry);
                    }
                    HashMap<String, MappingMetaData> mappingsMetaData = new HashMap<String, MappingMetaData>();
                    for (DocumentMapper documentMapper : mapperService.docMappers(true)) {
                        MappingMetaData mappingMetaData = new MappingMetaData(documentMapper);
                        mappingsMetaData.put(documentMapper.type(), mappingMetaData);
                    }
                    IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(request.index()).settings(settings).setRoutingNumShards(routingNumShards);
                    for (MappingMetaData mappingMetaData : mappingsMetaData.values()) {
                        indexMetaDataBuilder.putMapping(mappingMetaData);
                    }
                    for (AliasMetaData aliasMetaData : templatesAliases.values()) {
                        indexMetaDataBuilder.putAlias(aliasMetaData);
                    }
                    for (Alias alias : request.aliases()) {
                        AliasMetaData aliasMetaData = AliasMetaData.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).build();
                        indexMetaDataBuilder.putAlias(aliasMetaData);
                    }
                    for (Map.Entry entry : customs.entrySet()) {
                        indexMetaDataBuilder.putCustom((String)entry.getKey(), (IndexMetaData.Custom)entry.getValue());
                    }
                    indexMetaDataBuilder.state(request.state());
                    try {
                        indexMetaData = indexMetaDataBuilder.build();
                    }
                    catch (Exception exception) {
                        removalExtraInfo = "failed to build index metadata";
                        throw exception;
                    }
                    ((IndexService)indexService).getIndexEventListener().beforeIndexAddedToCluster(indexMetaData.getIndex(), indexMetaData.getSettings());
                    MetaData metaData = MetaData.builder(currentState.metaData()).put(indexMetaData, false).build();
                    String maybeShadowIndicator = IndexMetaData.isIndexUsingShadowReplicas(indexMetaData.getSettings()) ? "s" : "";
                    MetaDataCreateIndexService.this.logger.info("[{}] creating index, cause [{}], templates {}, shards [{}]/[{}{}], mappings {}", (Object)request.index(), (Object)request.cause(), templateNames, (Object)indexMetaData.getNumberOfShards(), (Object)indexMetaData.getNumberOfReplicas(), (Object)maybeShadowIndicator, mappings.keySet());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    if (!request.blocks().isEmpty()) {
                        for (ClusterBlock block : request.blocks()) {
                            blocks.addIndexBlock(request.index(), block);
                        }
                    }
                    blocks.updateBlocks(indexMetaData);
                    ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metaData(metaData).build();
                    if (request.state() == IndexMetaData.State.OPEN) {
                        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metaData().index(request.index()));
                        updatedState = MetaDataCreateIndexService.this.allocationService.reroute(ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build(), "index [" + request.index() + "] created");
                    }
                    removalExtraInfo = "cleaning up after validating index on master";
                    removalReason = IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED;
                    ClusterState clusterState = updatedState;
                    if (createdIndex != null) {
                        MetaDataCreateIndexService.this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                    }
                    return clusterState;
                }
                catch (Throwable throwable) {
                    if (createdIndex != null) {
                        MetaDataCreateIndexService.this.indicesService.removeIndex(createdIndex, removalReason, removalExtraInfo);
                    }
                    throw throwable;
                }
            }

            @Override
            public void onFailure(String source, Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    MetaDataCreateIndexService.this.logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                } else {
                    MetaDataCreateIndexService.this.logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                }
                super.onFailure(source, e);
            }
        });
    }

    private ContextPreservingActionListener<ClusterStateUpdateResponse> wrapPreservingContext(ActionListener<ClusterStateUpdateResponse> listener) {
        return new ContextPreservingActionListener<ClusterStateUpdateResponse>(this.threadPool.getThreadContext().newRestorableContext(false), listener);
    }

    private List<IndexTemplateMetaData> findTemplates(CreateIndexClusterStateUpdateRequest request, ClusterState state) throws IOException {
        ArrayList<IndexTemplateMetaData> templates = new ArrayList<IndexTemplateMetaData>();
        for (ObjectCursor cursor : state.metaData().templates().values()) {
            IndexTemplateMetaData template = (IndexTemplateMetaData)cursor.value;
            if (!Regex.simpleMatch(template.template(), request.index())) continue;
            templates.add(template);
        }
        CollectionUtil.timSort(templates, Comparator.comparingInt(IndexTemplateMetaData::order).reversed());
        return templates;
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        MetaDataCreateIndexService.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings());
    }

    public void validateIndexSettings(String indexName, Settings settings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, validationException);
        }
    }

    List<String> getIndexSettingsValidationErrors(Settings settings) {
        Path resolvedPath;
        String customPath = IndexMetaData.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isEmpty(customPath) && this.env.sharedDataFile() == null) {
            validationErrors.add("path.shared_data must be set in order to use custom data paths");
        } else if (!Strings.isEmpty(customPath) && (resolvedPath = PathUtils.get(new Path[]{this.env.sharedDataFile()}, customPath)) == null) {
            validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + this.env.sharedDataFile() + "]");
        }
        return validationErrors;
    }

    static List<String> validateShrinkIndex(ClusterState state, String sourceIndex, Set<String> targetIndexMappingsTypes, String targetIndexName, Settings targetIndexSettings) {
        if (state.metaData().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metaData().index(targetIndexName).getIndex());
        }
        IndexMetaData sourceMetaData = state.metaData().index(sourceIndex);
        if (sourceMetaData == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must be read-only to shrink index. use \"index.blocks.write=true\"");
        }
        if (sourceMetaData.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        if (targetIndexMappingsTypes.size() > 1 || !(targetIndexMappingsTypes.isEmpty() || targetIndexMappingsTypes.contains("_default_"))) {
            throw new IllegalArgumentException("mappings are not allowed when shrinking indices, all mappings are copied from the source index");
        }
        if (IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetaData.getRoutingFactor(sourceMetaData, IndexMetaData.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetaData.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void prepareShrinkIndexSettings(ClusterState currentState, Set<String> mappingKeys, Settings.Builder indexSettingsBuilder, Index shrinkFromIndex, String shrinkIntoName) {
        IndexMetaData sourceMetaData = currentState.metaData().index(shrinkFromIndex.getName());
        List<String> nodesToAllocateOn = MetaDataCreateIndexService.validateShrinkIndex(currentState, shrinkFromIndex.getName(), mappingKeys, shrinkIntoName, indexSettingsBuilder.build());
        Predicate<String> analysisSimilarityPredicate = s -> s.startsWith("index.similarity.") || s.startsWith("index.analysis.");
        indexSettingsBuilder.put("index.routing.allocation.initial_recovery._id", Strings.arrayToCommaDelimitedString(nodesToAllocateOn.toArray())).put("index.allocation.max_retries", 1).put(sourceMetaData.getSettings().filter(analysisSimilarityPredicate)).put(IndexMetaData.INDEX_SHRINK_SOURCE_NAME.getKey(), shrinkFromIndex.getName()).put(IndexMetaData.INDEX_SHRINK_SOURCE_UUID.getKey(), shrinkFromIndex.getUUID());
    }
}

