/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BlendedTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.search.MatchQuery;

public class MultiMatchQuery
extends MatchQuery {
    private Float groupTieBreaker = null;
    private QueryBuilder queryBuilder;

    public void setTieBreaker(float tieBreaker) {
        this.groupTieBreaker = Float.valueOf(tieBreaker);
    }

    public MultiMatchQuery(QueryShardContext context) {
        super(context);
    }

    private Query parseAndApply(MatchQuery.Type type, String fieldName, Object value, String minimumShouldMatch, Float boostValue) throws IOException {
        Query query = this.parse(type, fieldName, value);
        if (query instanceof BooleanQuery && !((BooleanQuery)query).isCoordDisabled()) {
            query = Queries.applyMinimumShouldMatch((BooleanQuery)query, minimumShouldMatch);
        }
        if (query != null && boostValue != null && boostValue.floatValue() != 1.0f) {
            query = new BoostQuery(query, boostValue.floatValue());
        }
        return query;
    }

    public Query parse(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
        Query result;
        if (fieldNames.size() == 1) {
            Map.Entry<String, Float> fieldBoost = fieldNames.entrySet().iterator().next();
            Float boostValue = fieldBoost.getValue();
            result = this.parseAndApply(type.matchQueryType(), fieldBoost.getKey(), value, minimumShouldMatch, boostValue);
        } else {
            float tieBreaker = this.groupTieBreaker == null ? type.tieBreaker() : this.groupTieBreaker.floatValue();
            switch (type) {
                case PHRASE: 
                case PHRASE_PREFIX: 
                case BEST_FIELDS: 
                case MOST_FIELDS: {
                    this.queryBuilder = new QueryBuilder(tieBreaker);
                    break;
                }
                case CROSS_FIELDS: {
                    this.queryBuilder = new CrossFieldsQueryBuilder(tieBreaker);
                    break;
                }
                default: {
                    throw new IllegalStateException("No such type: " + type);
                }
            }
            List<Query> queries = this.queryBuilder.buildGroupedQueries(type, fieldNames, value, minimumShouldMatch);
            result = this.queryBuilder.combineGrouped(queries);
        }
        assert (result != null);
        return result;
    }

    static Query blendTerm(QueryShardContext context, BytesRef value, Float commonTermsCutoff, float tieBreaker, FieldAndFieldType ... blendedFields) {
        return MultiMatchQuery.blendTerms(context, new BytesRef[]{value}, commonTermsCutoff, tieBreaker, blendedFields);
    }

    static Query blendTerms(QueryShardContext context, BytesRef[] values, Float commonTermsCutoff, float tieBreaker, FieldAndFieldType ... blendedFields) {
        ArrayList<Query> queries = new ArrayList<Query>();
        Term[] terms = new Term[blendedFields.length * values.length];
        float[] blendedBoost = new float[blendedFields.length * values.length];
        int i = 0;
        for (FieldAndFieldType ft : blendedFields) {
            for (BytesRef term : values) {
                Query query;
                try {
                    query = ft.fieldType.termQuery(term, context);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                catch (ElasticsearchParseException parseException) {
                    if (parseException.getCause() instanceof IllegalArgumentException) continue;
                    throw parseException;
                }
                float boost = ft.boost;
                while (query instanceof BoostQuery) {
                    BoostQuery bq = (BoostQuery)query;
                    query = bq.getQuery();
                    boost *= bq.getBoost();
                }
                if (query.getClass() == TermQuery.class) {
                    terms[i] = ((TermQuery)query).getTerm();
                    blendedBoost[i] = boost;
                    ++i;
                    continue;
                }
                if (boost != 1.0f) {
                    query = new BoostQuery(query, boost);
                }
                queries.add(query);
            }
        }
        if (i > 0) {
            terms = Arrays.copyOf(terms, i);
            blendedBoost = Arrays.copyOf(blendedBoost, i);
            if (commonTermsCutoff != null) {
                queries.add(BlendedTermQuery.commonTermsBlendedQuery(terms, blendedBoost, false, commonTermsCutoff.floatValue()));
            } else if (tieBreaker == 1.0f) {
                queries.add(BlendedTermQuery.booleanBlendedQuery(terms, blendedBoost, false));
            } else {
                queries.add(BlendedTermQuery.dismaxBlendedQuery(terms, blendedBoost, tieBreaker));
            }
        }
        if (queries.size() == 1) {
            return (Query)queries.get(0);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Query query : queries) {
            bq.add(query, BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    @Override
    protected Query blendTermQuery(Term term, MappedFieldType fieldType) {
        if (this.queryBuilder == null) {
            return super.blendTermQuery(term, fieldType);
        }
        return this.queryBuilder.blendTerm(term, fieldType);
    }

    @Override
    protected Query blendTermsQuery(Term[] terms, MappedFieldType fieldType) {
        if (this.queryBuilder == null) {
            return super.blendTermsQuery(terms, fieldType);
        }
        return this.queryBuilder.blendTerms(terms, fieldType);
    }

    static final class FieldAndFieldType {
        final MappedFieldType fieldType;
        final float boost;

        FieldAndFieldType(MappedFieldType fieldType, float boost) {
            this.fieldType = Objects.requireNonNull(fieldType);
            this.boost = boost;
        }
    }

    final class CrossFieldsQueryBuilder
    extends QueryBuilder {
        private FieldAndFieldType[] blendedFields;

        public CrossFieldsQueryBuilder(float tieBreaker) {
            super(false, tieBreaker);
        }

        @Override
        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            HashMap groups = new HashMap();
            ArrayList<Tuple<String, Float>> missing = new ArrayList<Tuple<String, Float>>();
            for (Map.Entry<String, Float> entry : fieldNames.entrySet()) {
                String string = entry.getKey();
                MappedFieldType fieldType = MultiMatchQuery.this.context.fieldMapper(string);
                if (fieldType != null) {
                    Float boost;
                    Analyzer actualAnalyzer = MultiMatchQuery.this.getAnalyzer(fieldType);
                    String string2 = fieldType.name();
                    if (!groups.containsKey(actualAnalyzer)) {
                        groups.put(actualAnalyzer, new ArrayList());
                    }
                    boost = (boost = entry.getValue()) == null ? Float.valueOf(1.0f) : boost;
                    ((List)groups.get(actualAnalyzer)).add(new FieldAndFieldType(fieldType, boost.floatValue()));
                    continue;
                }
                missing.add(new Tuple<String, Float>(string, entry.getValue()));
            }
            ArrayList<Query> queries = new ArrayList<Query>();
            for (Tuple tuple : missing) {
                Query q = this.parseGroup(type.matchQueryType(), (String)tuple.v1(), (Float)tuple.v2(), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            for (List list : groups.values()) {
                if (list.size() > 1) {
                    this.blendedFields = new FieldAndFieldType[list.size()];
                    int i = 0;
                    for (FieldAndFieldType fieldAndFieldType : list) {
                        this.blendedFields[i++] = fieldAndFieldType;
                    }
                } else {
                    this.blendedFields = null;
                }
                String representativeField = ((FieldAndFieldType)list.get((int)0)).fieldType.name();
                Query q = this.parseGroup(type.matchQueryType(), representativeField, Float.valueOf(1.0f), value, minimumShouldMatch);
                if (q == null) continue;
                queries.add(q);
            }
            return queries.isEmpty() ? null : queries;
        }

        @Override
        public Query blendTerms(Term[] terms, MappedFieldType fieldType) {
            if (this.blendedFields == null || this.blendedFields.length == 1) {
                return super.blendTerms(terms, fieldType);
            }
            BytesRef[] values = new BytesRef[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                values[i] = terms[i].bytes();
            }
            return MultiMatchQuery.blendTerms(MultiMatchQuery.this.context, values, MultiMatchQuery.this.commonTermsCutoff, this.tieBreaker, this.blendedFields);
        }

        @Override
        public Query blendTerm(Term term, MappedFieldType fieldType) {
            if (this.blendedFields == null) {
                return super.blendTerm(term, fieldType);
            }
            return MultiMatchQuery.blendTerm(MultiMatchQuery.this.context, term.bytes(), MultiMatchQuery.this.commonTermsCutoff, this.tieBreaker, this.blendedFields);
        }

        @Override
        public Query termQuery(MappedFieldType fieldType, Object value) {
            return this.blendTerm(new Term(fieldType.name(), value.toString()), fieldType);
        }
    }

    public class QueryBuilder {
        protected final boolean groupDismax;
        protected final float tieBreaker;

        public QueryBuilder(float tieBreaker) {
            this(tieBreaker != 1.0f, tieBreaker);
        }

        public QueryBuilder(boolean groupDismax, float tieBreaker) {
            this.groupDismax = groupDismax;
            this.tieBreaker = tieBreaker;
        }

        public List<Query> buildGroupedQueries(MultiMatchQueryBuilder.Type type, Map<String, Float> fieldNames, Object value, String minimumShouldMatch) throws IOException {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (String fieldName : fieldNames.keySet()) {
                Float boostValue = fieldNames.get(fieldName);
                Query query = this.parseGroup(type.matchQueryType(), fieldName, boostValue, value, minimumShouldMatch);
                if (query == null) continue;
                queries.add(query);
            }
            return queries;
        }

        public Query parseGroup(MatchQuery.Type type, String field, Float boostValue, Object value, String minimumShouldMatch) throws IOException {
            return MultiMatchQuery.this.parseAndApply(type, field, value, minimumShouldMatch, boostValue);
        }

        private Query combineGrouped(List<? extends Query> groupQuery) {
            if (groupQuery == null || groupQuery.isEmpty()) {
                return new MatchNoDocsQuery("[multi_match] list of group queries was empty");
            }
            if (groupQuery.size() == 1) {
                return groupQuery.get(0);
            }
            if (this.groupDismax) {
                ArrayList<Query> queries = new ArrayList<Query>();
                for (Query query : groupQuery) {
                    queries.add(query);
                }
                return new DisjunctionMaxQuery(queries, this.tieBreaker);
            }
            BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
            for (Query query : groupQuery) {
                booleanQuery.add(query, BooleanClause.Occur.SHOULD);
            }
            return booleanQuery.build();
        }

        public Query blendTerm(Term term, MappedFieldType fieldType) {
            return MultiMatchQuery.super.blendTermQuery(term, fieldType);
        }

        public Query blendTerms(Term[] terms, MappedFieldType fieldType) {
            return MultiMatchQuery.super.blendTermsQuery(terms, fieldType);
        }

        public Query termQuery(MappedFieldType fieldType, Object value) {
            return MultiMatchQuery.this.termQuery(fieldType, value, MultiMatchQuery.this.lenient);
        }
    }
}

