/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.TransportStatus;
import org.elasticsearch.transport.local.LocalTransport;

public class LocalTransportChannel
implements TransportChannel {
    private static final String LOCAL_TRANSPORT_PROFILE = "default";
    private final LocalTransport sourceTransport;
    private final TransportServiceAdapter sourceTransportServiceAdapter;
    private final LocalTransport targetTransport;
    private final String action;
    private final long requestId;
    private final Version version;
    private final long reservedBytes;
    private final ThreadContext threadContext;
    private final AtomicBoolean closed = new AtomicBoolean();

    public LocalTransportChannel(LocalTransport sourceTransport, TransportServiceAdapter sourceTransportServiceAdapter, LocalTransport targetTransport, String action, long requestId, Version version, long reservedBytes, ThreadContext threadContext) {
        this.sourceTransport = sourceTransport;
        this.sourceTransportServiceAdapter = sourceTransportServiceAdapter;
        this.targetTransport = targetTransport;
        this.action = action;
        this.requestId = requestId;
        this.version = version;
        this.reservedBytes = reservedBytes;
        this.threadContext = threadContext;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public String getProfileName() {
        return LOCAL_TRANSPORT_PROFILE;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
        try (BytesStreamOutput stream = new BytesStreamOutput();){
            stream.setVersion(this.version);
            stream.writeLong(this.requestId);
            byte status = 0;
            status = TransportStatus.setResponse(status);
            stream.writeByte(status);
            this.threadContext.writeTo(stream);
            response.writeTo(stream);
            this.sendResponseData(BytesReference.toBytes(stream.bytes()));
            this.sourceTransportServiceAdapter.onResponseSent(this.requestId, this.action, response, options);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        BytesStreamOutput stream = new BytesStreamOutput();
        stream.setVersion(this.version);
        this.writeResponseExceptionHeader(stream);
        RemoteTransportException tx = new RemoteTransportException(this.targetTransport.nodeName(), this.targetTransport.boundAddress().boundAddresses()[0], this.action, exception);
        stream.writeException(tx);
        this.sendResponseData(BytesReference.toBytes(stream.bytes()));
        this.sourceTransportServiceAdapter.onResponseSent(this.requestId, this.action, exception);
    }

    private void sendResponseData(byte[] data) {
        this.close();
        this.targetTransport.receiveMessage(this.version, data, this.action, null, this.sourceTransport);
    }

    private void close() {
        if (!this.closed.compareAndSet(false, true)) {
            throw new IllegalStateException("Channel is already closed");
        }
        this.sourceTransport.inFlightRequestsBreaker().addWithoutBreaking(-this.reservedBytes);
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public String getChannelType() {
        return "local";
    }

    private void writeResponseExceptionHeader(BytesStreamOutput stream) throws IOException {
        stream.writeLong(this.requestId);
        byte status = 0;
        status = TransportStatus.setResponse(status);
        status = TransportStatus.setError(status);
        stream.writeByte(status);
        this.threadContext.writeTo(stream);
    }
}

