/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.output.definitions;

import java.io.File;
import java.util.List;
import org.gradle.foundation.output.FileLink;
import org.gradle.foundation.output.definitions.FileLinkDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixedFileLinkDefinition
implements FileLinkDefinition {
    private String expression;
    private String prefix;
    private String lineNumberDelimiter;
    private String extension;
    private String name;

    public PrefixedFileLinkDefinition(String name, String prefix, String extension) {
        this(name, prefix, extension, null);
    }

    public PrefixedFileLinkDefinition(String name, String prefix, String extension, String lineNumberDelimiter) {
        this.name = name;
        this.prefix = prefix;
        this.lineNumberDelimiter = lineNumberDelimiter;
        this.extension = extension;
        String regExLiteralPrefix = PrefixedFileLinkDefinition.quoteLiteral(prefix);
        this.expression = regExLiteralPrefix + ".*\\" + extension;
        if (lineNumberDelimiter != null) {
            this.expression = this.expression + this.generateLineNumberExpression(lineNumberDelimiter);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String generateLineNumberExpression(String lineNumberDelimiter) {
        return PrefixedFileLinkDefinition.quoteLiteral(lineNumberDelimiter) + "\\d*";
    }

    public static String quoteLiteral(String literal) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < literal.length(); ++index) {
            char c = literal.charAt(index);
            if (PrefixedFileLinkDefinition.isEscapedCharater(c)) {
                builder.append('\\').append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean isEscapedCharater(char c) {
        return c == '[' || c == ']' || c == '(' || c == ')' || c == '{' || c == '}' || c == '\\' || c == '\"' || c == '$' || c == '&' || c == '|' || c == '^' || c == '?' || c == '*' || c == '.';
    }

    @Override
    public String getSearchExpression() {
        return this.expression;
    }

    @Override
    public int parseFileLink(String fullSearchTest, String matchedText, int start, int end, boolean verifyFileExists, List<FileLink> fileLinks) {
        int extensionIndex = matchedText.lastIndexOf(this.extension);
        if (extensionIndex == -1) {
            return -1;
        }
        int prefixIndex = this.getStartOfFile(matchedText);
        int realPathEnd = extensionIndex + this.extension.length();
        String path = matchedText.substring(prefixIndex, realPathEnd).trim();
        File file = new File(path);
        if (verifyFileExists && !file.exists()) {
            return -1;
        }
        String remainder = matchedText.substring(realPathEnd);
        int lineNumber = PrefixedFileLinkDefinition.getLineNumber(remainder, this.lineNumberDelimiter);
        fileLinks.add(new FileLink(file, start + prefixIndex, end, lineNumber, this));
        return end;
    }

    private int getStartOfFile(String matchedText) {
        int index = this.prefix.length();
        while (Character.isWhitespace(matchedText.charAt(index))) {
            ++index;
        }
        return index;
    }

    public static int getLineNumber(String textAfterPath, String lineNumberDelimiter) {
        int lineDelimterIndex;
        if (lineNumberDelimiter != null && (lineDelimterIndex = textAfterPath.indexOf(lineNumberDelimiter)) != -1) {
            String lineNumberText = textAfterPath.substring(lineDelimterIndex + lineNumberDelimiter.length());
            lineNumberText = lineNumberText.trim();
            if (!"".equals(lineNumberText = PrefixedFileLinkDefinition.getConsecutiveNumbers(lineNumberText))) {
                return Integer.parseInt(lineNumberText);
            }
        }
        return -1;
    }

    public static String getConsecutiveNumbers(String text) {
        StringBuilder numbersOnly = new StringBuilder();
        boolean keepLooking = true;
        for (int index = 0; keepLooking && index < text.length(); ++index) {
            char c = text.charAt(index);
            if (Character.isDigit(c)) {
                numbersOnly.append(c);
                continue;
            }
            keepLooking = false;
        }
        return numbersOnly.toString();
    }

    public String toString() {
        return "Name: '" + this.name + "'" + " Expression ='" + this.expression + '\'' + " Prefix='" + this.prefix + '\'' + " LineNumberDelimter='" + this.lineNumberDelimiter + '\'' + " Extension='" + this.extension + '\'';
    }
}

