/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.composite.internal.CompositeBuildIdeProjectResolver;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.eclipse.model.EclipseWtpComponent;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.WbDependentModule;
import org.gradle.plugins.ide.eclipse.model.WbResource;
import org.gradle.plugins.ide.eclipse.model.WtpComponent;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;

public class WtpComponentFactory {
    private final CompositeBuildIdeProjectResolver ideProjectResolver;

    public WtpComponentFactory(Project project) {
        this.ideProjectResolver = CompositeBuildIdeProjectResolver.from((ServiceRegistry)((ProjectInternal)project).getServices());
    }

    public void configure(EclipseWtpComponent wtp, WtpComponent component) {
        ArrayList entries = Lists.newArrayList();
        entries.addAll(this.getEntriesFromSourceDirs(wtp));
        for (WbResource element : wtp.getResources()) {
            if (!wtp.getProject().file((Object)element.getSourcePath()).isDirectory()) continue;
            entries.add(element);
        }
        entries.addAll(wtp.getProperties());
        Project project = wtp.getProject();
        entries.addAll(this.getEntriesFromConfigurations(project, this.configOrEmptySet(wtp.getRootConfigurations()), this.configOrEmptySet(wtp.getMinusConfigurations()), wtp, "/"));
        entries.addAll(this.getEntriesFromConfigurations(project, this.configOrEmptySet(wtp.getLibConfigurations()), this.configOrEmptySet(wtp.getMinusConfigurations()), wtp, wtp.getLibDeployPath()));
        component.configure(wtp.getDeployName(), wtp.getContextPath(), entries);
    }

    private Set<Configuration> configOrEmptySet(Set<Configuration> configuration) {
        if (configuration == null) {
            return Sets.newHashSet();
        }
        return configuration;
    }

    private List<WbResource> getEntriesFromSourceDirs(EclipseWtpComponent wtp) {
        ArrayList result = Lists.newArrayList();
        if (wtp.getSourceDirs() != null) {
            for (File dir : wtp.getSourceDirs()) {
                if (!dir.isDirectory()) continue;
                result.add(new WbResource(wtp.getClassesDeployPath(), wtp.getProject().relativePath((Object)dir)));
            }
        }
        return result;
    }

    private List<WbDependentModule> getEntriesFromConfigurations(Project project, Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, EclipseWtpComponent wtp, String deployPath) {
        ArrayList entries = Lists.newArrayList();
        entries.addAll(this.getEntriesFromProjectDependencies(project, plusConfigurations, minusConfigurations, deployPath));
        if (!project.getPlugins().hasPlugin(JavaPlugin.class)) {
            entries.addAll(this.getEntriesFromLibraries(plusConfigurations, minusConfigurations, wtp, deployPath));
        }
        return entries;
    }

    private List<WbDependentModule> getEntriesFromProjectDependencies(Project project, Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, String deployPath) {
        IdeDependenciesExtractor extractor = new IdeDependenciesExtractor();
        Collection<IdeProjectDependency> dependencies = extractor.extractProjectDependencies(project, plusConfigurations, minusConfigurations);
        ArrayList projectDependencies = Lists.newArrayList();
        for (IdeProjectDependency dependency : dependencies) {
            String moduleName = this.determineProjectName(dependency);
            projectDependencies.add(new WbDependentModule(deployPath, "module:/resource/" + moduleName + "/" + moduleName));
        }
        return projectDependencies;
    }

    private String determineProjectName(IdeProjectDependency dependency) {
        LocalComponentArtifactMetadata eclipseProjectArtifact = this.ideProjectResolver.findArtifact(dependency.getProjectId(), "eclipse.project");
        return eclipseProjectArtifact == null ? dependency.getProjectName() : eclipseProjectArtifact.getName().getName();
    }

    private List<WbDependentModule> getEntriesFromLibraries(Set<Configuration> plusConfigurations, Set<Configuration> minusConfigurations, EclipseWtpComponent wtp, String deployPath) {
        IdeDependenciesExtractor extractor = new IdeDependenciesExtractor();
        Collection<IdeExtendedRepoFileDependency> externals = extractor.resolvedExternalDependencies(plusConfigurations, minusConfigurations);
        Collection<IdeLocalFileDependency> locals = extractor.extractLocalFileDependencies(plusConfigurations, minusConfigurations);
        ArrayList libFiles = Lists.newArrayList();
        for (IdeExtendedRepoFileDependency ideExtendedRepoFileDependency : externals) {
            libFiles.add(ideExtendedRepoFileDependency.getFile());
        }
        for (IdeLocalFileDependency ideLocalFileDependency : locals) {
            libFiles.add(ideLocalFileDependency.getFile());
        }
        ArrayList libraryEntries = Lists.newArrayList();
        for (File file : libFiles) {
            libraryEntries.add(this.createWbDependentModuleEntry(file, wtp.getFileReferenceFactory(), deployPath));
        }
        return libraryEntries;
    }

    private WbDependentModule createWbDependentModuleEntry(File file, FileReferenceFactory fileReferenceFactory, String deployPath) {
        FileReference ref = fileReferenceFactory.fromFile(file);
        String handleSnippet = ref.isRelativeToPathVariable() ? "var/" + ref.getPath() : "lib/" + ref.getPath();
        return new WbDependentModule(deployPath, "module:/classpath/" + handleSnippet);
    }
}

