/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.attributes;

import java.util.NoSuchElementException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.internal.Cast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValue<T> {
    private static final AttributeValue<Object> MISSING = new AttributeValue<Object>(null){

        @Override
        public boolean isMissing() {
            return true;
        }

        @Override
        public Object get() {
            throw new InvalidUserCodeException("get() should not be called on a missing attribute value");
        }
    };
    private static final AttributeValue<Object> UNKNOWN = new AttributeValue<Object>(null){

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public Object get() {
            throw new InvalidUserCodeException("get() should not be called on an unknown attribute value");
        }
    };
    private final T value;

    private AttributeValue(T value) {
        this.value = value;
    }

    public static <T> AttributeValue<T> of(T value) {
        return new AttributeValue<T>(value);
    }

    public static <T> AttributeValue<T> missing() {
        return (AttributeValue)Cast.uncheckedCast(MISSING);
    }

    public static <T> AttributeValue<T> unknown() {
        return (AttributeValue)Cast.uncheckedCast(UNKNOWN);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value provided");
        }
        return this.value;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isMissing() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeValue that = (AttributeValue)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

