/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.collections.DefaultDirectoryWalker;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.internal.file.collections.jdk7.Jdk7DirectoryWalker;
import org.gradle.internal.Factory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDirectoryWalkerFactory
implements Factory<DirectoryWalker> {
    private final JavaVersion javaVersion;
    private final org.gradle.internal.nativeplatform.filesystem.FileSystem fileSystem;
    private DirectoryWalker instance;

    public DefaultDirectoryWalkerFactory(JavaVersion javaVersion, org.gradle.internal.nativeplatform.filesystem.FileSystem fileSystem) {
        this.javaVersion = javaVersion;
        this.fileSystem = fileSystem;
        this.reset();
    }

    DefaultDirectoryWalkerFactory() {
        this(JavaVersion.current(), FileSystems.getDefault());
    }

    public DirectoryWalker create() {
        return this.instance;
    }

    private void reset() {
        this.instance = this.createInstance();
    }

    private DirectoryWalker createInstance() {
        if (this.javaVersion.isJava8Compatible() || this.javaVersion.isJava7Compatible() && this.defaultEncodingContainsPlatformEncoding()) {
            return new Jdk7DirectoryWalker((FileSystem)this.fileSystem);
        }
        return new DefaultDirectoryWalker((FileSystem)this.fileSystem);
    }

    private boolean defaultEncodingContainsPlatformEncoding() {
        String platformEncoding = System.getProperty("sun.jnu.encoding");
        Charset platformCharset = platformEncoding != null && Charset.isSupported(platformEncoding) ? Charset.forName(platformEncoding) : null;
        Charset requiredCharset = platformCharset != null ? platformCharset : Charsets.UTF_8;
        return Charset.defaultCharset().contains(requiredCharset);
    }
}

