/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import org.gradle.api.Nullable;
import org.gradle.internal.progress.BuildOperationExecutor;

public class BuildOperationDetails {
    private final BuildOperationExecutor.Operation parent;
    private final String displayName;
    private final String name;
    private final String progressDisplayName;
    private final Object operationDescriptor;

    private BuildOperationDetails(BuildOperationExecutor.Operation parent, String name, String displayName, String progressDisplayName, Object operationDescriptor) {
        this.parent = parent;
        this.name = name;
        this.displayName = displayName;
        this.progressDisplayName = progressDisplayName;
        this.operationDescriptor = operationDescriptor;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getProgressDisplayName() {
        return this.progressDisplayName;
    }

    @Nullable
    public Object getOperationDescriptor() {
        return this.operationDescriptor;
    }

    @Nullable
    public BuildOperationExecutor.Operation getParent() {
        return this.parent;
    }

    public static Builder displayName(String displayName) {
        return new Builder(displayName);
    }

    public static class Builder {
        private final String displayName;
        private String name;
        private BuildOperationExecutor.Operation parent;
        private String progressDisplayName;
        private Object operationDescriptor;

        private Builder(String displayName) {
            this.displayName = displayName;
            this.name = displayName;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder progressDisplayName(String progressDisplayName) {
            this.progressDisplayName = progressDisplayName;
            return this;
        }

        public Builder operationDescriptor(Object descriptor) {
            this.operationDescriptor = descriptor;
            return this;
        }

        public Builder parent(BuildOperationExecutor.Operation parent) {
            this.parent = parent;
            return this;
        }

        public BuildOperationDetails build() {
            return new BuildOperationDetails(this.parent, this.name, this.displayName, this.progressDisplayName, this.operationDescriptor);
        }
    }
}

