/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.TypedNotationConverter;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.util.GUtil;

public class ModuleIdentifierNotationConverter
extends TypedNotationConverter<String, ModuleIdentifier> {
    private static final List<Character> INVALID_SPEC_CHARS = Lists.newArrayList((Object[])new Character[]{Character.valueOf('*'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(','), Character.valueOf('+')});

    public ModuleIdentifierNotationConverter() {
        super(String.class);
    }

    protected ModuleIdentifier parseType(String notation) {
        assert (notation != null);
        String[] split = notation.split(":");
        if (split.length != 2) {
            throw new UnsupportedNotationException((Object)notation);
        }
        String group = ModuleIdentifierNotationConverter.validate(split[0].trim(), notation);
        String name = ModuleIdentifierNotationConverter.validate(split[1].trim(), notation);
        return DefaultModuleIdentifier.newId(group, name);
    }

    public static String validate(String part, String notation) {
        if (!GUtil.isTrue((Object)part)) {
            throw new UnsupportedNotationException((Object)notation);
        }
        for (char c : INVALID_SPEC_CHARS) {
            if (part.indexOf(c) == -1) continue;
            throw new UnsupportedNotationException((Object)notation);
        }
        return part;
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("String describing the module in 'group:name' format").example("'org.gradle:gradle-core'.");
    }
}

