/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.util.AbstractQuery;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.QueryExecutor;

public final class ExecutorsQuery<Result, Parameter>
extends AbstractQuery<Result> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ExecutorsQuery");
    private final List<QueryExecutor<Result, Parameter>> myExecutors;
    private final Parameter myParameters;

    public ExecutorsQuery(@NotNull Parameter params, @NotNull List<QueryExecutor<Result, Parameter>> executors) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/com/intellij/util/ExecutorsQuery", "<init>"));
        }
        if (executors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executors", "org/jetbrains/kotlin/com/intellij/util/ExecutorsQuery", "<init>"));
        }
        this.myParameters = params;
        this.myExecutors = executors;
    }

    @Override
    protected boolean processResults(@NotNull Processor<Result> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/util/ExecutorsQuery", "processResults"));
        }
        for (QueryExecutor<Result, Parameter> executor : this.myExecutors) {
            try {
                ProgressManager.checkCanceled();
                if (executor.execute(this.myParameters, consumer)) continue;
                return false;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }
}

