/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.match.ContentRequestMatchers;
import org.springframework.test.web.client.match.JsonPathRequestMatchers;
import org.springframework.test.web.client.match.XpathRequestMatchers;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class MockRestRequestMatchers {
    public static RequestMatcher anything() {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws AssertionError {
            }
        };
    }

    public static RequestMatcher method(final HttpMethod method) {
        org.springframework.util.Assert.notNull((Object)method, (String)"'method' must not be null");
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws AssertionError {
                AssertionErrors.assertEquals("Unexpected HttpMethod", method, request.getMethod());
            }
        };
    }

    public static RequestMatcher requestTo(final Matcher<String> matcher) {
        org.springframework.util.Assert.notNull(matcher, (String)"'matcher' must not be null");
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                MatcherAssert.assertThat((String)"Request URI", (Object)request.getURI().toString(), (Matcher)matcher);
            }
        };
    }

    public static RequestMatcher requestTo(final String expectedUri) {
        org.springframework.util.Assert.notNull((Object)expectedUri, (String)"'uri' must not be null");
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                AssertionErrors.assertEquals("Request URI", expectedUri, request.getURI().toString());
            }
        };
    }

    public static RequestMatcher requestTo(final URI uri) {
        org.springframework.util.Assert.notNull((Object)uri, (String)"'uri' must not be null");
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) throws IOException, AssertionError {
                AssertionErrors.assertEquals("Unexpected request", uri, request.getURI());
            }
        };
    }

    @SafeVarargs
    public static RequestMatcher queryParam(final String name, final Matcher<? super String> ... matchers) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) {
                MultiValueMap params = MockRestRequestMatchers.getQueryParams(request);
                MockRestRequestMatchers.assertValueCount("query param", name, (MultiValueMap<String, String>)params, matchers.length);
                for (int i = 0; i < matchers.length; ++i) {
                    MatcherAssert.assertThat((String)"Query param", ((List)params.get((Object)name)).get(i), (Matcher)matchers[i]);
                }
            }
        };
    }

    public static RequestMatcher queryParam(final String name, final String ... expectedValues) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) {
                MultiValueMap params = MockRestRequestMatchers.getQueryParams(request);
                MockRestRequestMatchers.assertValueCount("query param", name, (MultiValueMap<String, String>)params, expectedValues.length);
                for (int i = 0; i < expectedValues.length; ++i) {
                    AssertionErrors.assertEquals("Query param + [" + name + "]", expectedValues[i], ((List)params.get((Object)name)).get(i));
                }
            }
        };
    }

    private static MultiValueMap<String, String> getQueryParams(ClientHttpRequest request) {
        return UriComponentsBuilder.fromUri((URI)request.getURI()).build().getQueryParams();
    }

    private static void assertValueCount(String valueType, String name, MultiValueMap<String, String> map, int count) {
        List values = (List)map.get((Object)name);
        String message = "Expected " + valueType + " <" + name + ">";
        Assert.assertNotNull((String)message, (Object)values);
        AssertionErrors.assertTrue(message + " to have at least <" + count + "> values but found " + values, count <= values.size());
    }

    @SafeVarargs
    public static RequestMatcher header(final String name, final Matcher<? super String> ... matchers) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) {
                MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)((MultiValueMap)request.getHeaders()), matchers.length);
                for (int i = 0; i < matchers.length; ++i) {
                    MatcherAssert.assertThat((String)"Request header", request.getHeaders().get((Object)name).get(i), (Matcher)matchers[i]);
                }
            }
        };
    }

    public static RequestMatcher header(final String name, final String ... expectedValues) {
        return new RequestMatcher(){

            @Override
            public void match(ClientHttpRequest request) {
                MockRestRequestMatchers.assertValueCount("header", name, (MultiValueMap<String, String>)((MultiValueMap)request.getHeaders()), expectedValues.length);
                for (int i = 0; i < expectedValues.length; ++i) {
                    AssertionErrors.assertEquals("Request header + [" + name + "]", expectedValues[i], request.getHeaders().get((Object)name).get(i));
                }
            }
        };
    }

    public static ContentRequestMatchers content() {
        return new ContentRequestMatchers();
    }

    public static JsonPathRequestMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathRequestMatchers(expression, args);
    }

    public static <T> RequestMatcher jsonPath(String expression, Matcher<T> matcher) {
        return new JsonPathRequestMatchers(expression, new Object[0]).value(matcher);
    }

    public static XpathRequestMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, null, args);
    }

    public static XpathRequestMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathRequestMatchers(expression, namespaces, args);
    }
}

