/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.search.StringRef;
import javax.swing.Icon;

public class CodeNode
extends JNode {
    private static final long serialVersionUID = 1658650786734966545L;
    private final JNode jNode;
    private final JClass jParent;
    private final StringRef line;
    private final int lineNum;

    public CodeNode(JNode jNode, int lineNum, StringRef line) {
        this.jNode = jNode;
        this.jParent = this.jNode.getJParent();
        this.line = line;
        this.lineNum = lineNum;
    }

    @Override
    public Icon getIcon() {
        return this.jNode.getIcon();
    }

    @Override
    public JavaNode getJavaNode() {
        return this.jNode.getJavaNode();
    }

    @Override
    public JClass getJParent() {
        return this.getRootClass();
    }

    @Override
    public JClass getRootClass() {
        JClass parent = this.jParent;
        if (parent != null) {
            return parent.getRootClass();
        }
        if (this.jNode instanceof JClass) {
            return (JClass)this.jNode;
        }
        return null;
    }

    @Override
    public int getLine() {
        return this.lineNum;
    }

    @Override
    public String makeDescString() {
        return this.line.toString();
    }

    @Override
    public boolean hasDescString() {
        return true;
    }

    @Override
    public String makeString() {
        return this.jNode.makeLongString();
    }

    @Override
    public String makeLongString() {
        return this.makeString();
    }
}

