/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Stack;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gennbo.NBODialog;
import org.gennbo.NBODialogConfig;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBORequest;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.util.Elements;

abstract class NBODialogModel
extends NBODialogConfig {
    private static final int MODEL_ACTION_ALTER = 0;
    private static final int MODEL_ACTION_CLIP = 1;
    private static final int MODEL_ACTION_FUSE = 2;
    private static final int MODEL_ACTION_LINK = 3;
    private static final int MODEL_ACTION_MUTATE = 4;
    private static final int MODEL_ACTION_SWITCH = 5;
    private static final int MODEL_ACTION_TWIST = 6;
    private static final int MODEL_ACTION_VALUE = 7;
    private static final int MODEL_ACTION_3CHB = 8;
    private static final int MODEL_ACTION_MAX = 9;
    private static final int MODEL_ACTION_REBOND = 9;
    private static final int MODEL_ACTION_SYMMETRY = 10;
    static final String[] MODEL_ACTIONS = new String[]{"Alter", "Clip", "Fuse", "Link", "Mutate", "Switch", "Twist", "Value", "3chb", "Rebond", "Symmetry?"};
    private static final String[] EDIT_INFO = new String[]{"Edit nuclear charge, bond length, bond angle, or dihedral angle", "Remove bond between two atoms", "Delete monovalent atoms and replace with bond", "Add bond between two atoms", "Replace atom with a new substituent-group", "Switch location of two groups", "Perform rigid torsional twist about dihedral angle", "Value of nuclear charge, bond length, bond angle, and dihedral angle", "Create 3-center linkage between two atoms and a ligand", "Change bonding symmetry around transition metal", "Display point-group symmetry of current model"};
    private static final int BOX_COUNT_4 = 4;
    private static final int BOX_COUNT_2 = 2;
    private static final int BOX_COUNT_1 = 1;
    private static final int MAX_HISTORY = 5;
    private NBOFileHandler saveFileHandler;
    private Box innerEditBox;
    private JTextField jtNIHInput;
    private JTextField jtLineFormula;
    private JTextField currVal;
    private JComboBox<String> jcSymOps;
    private JButton rebond;
    private JButton jbClear;
    private JLabel atomsLabel;
    private Box editComponent;
    private Box inputHeader;
    private Box saveHeader;
    private Component inputComponent;
    private Box saveComponent;
    private Box editHeader;
    private JTextField[] atomNumBoxes;
    private JLabel valueLabel = new JLabel("");
    protected JTextField editValueTf;
    protected JButton jbApply;
    protected JComboBox<String> jComboSave;
    protected JButton undo;
    protected JButton redo;
    protected Stack<String> undoStack;
    protected Stack<String> redoStack;
    JPanel panel;
    private int actionID;
    private int boxCount;
    private boolean notFromNBO;
    private boolean resetOnAtomClick;
    ActionListener redoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBODialogModel.this.redoStack.pop();
            if (NBODialogModel.this.redoStack.isEmpty()) {
                NBODialogModel.this.redo.setEnabled(false);
            }
            NBODialogModel.this.loadModelToNBO(curr, true);
            NBODialogModel.this.logCmd("Redo");
        }
    };
    ActionListener undoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBODialogModel.this.undoStack.pop();
            if (NBODialogModel.this.undoStack.isEmpty()) {
                NBODialogModel.this.undo.setEnabled(false);
                return;
            }
            String tmp = NBODialogModel.this.undoStack.pop();
            NBODialogModel.this.loadModelToNBO(tmp, true);
            NBODialogModel.this.redoStack.push(curr);
            if (NBODialogModel.this.redoStack.size() > 5) {
                NBODialogModel.this.redoStack.removeElementAt(5);
            }
            NBODialogModel.this.logCmd("Undo");
        }
    };

    protected NBODialogModel(JFrame f) {
        super(f);
    }

    protected void setModelNotFromNBO() {
        this.notFromNBO = true;
    }

    private void showComponents(boolean tf) {
        this.editHeader.setVisible(tf);
        this.editComponent.setVisible(tf);
        this.saveHeader.setVisible(tf);
        this.saveComponent.setVisible(tf);
    }

    void modelSetSaveParametersFromInput(NBOFileHandler nboFileHandler, String dir, String name, String ext) {
        if (this.saveFileHandler != null && nboFileHandler != this.saveFileHandler) {
            this.saveFileHandler.setInput(dir, name, PT.isOneOf(ext, "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com") ? ext : "");
        }
    }

    protected JPanel buildModelPanel() {
        this.resetVariables_m();
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.inputHeader = NBODialogModel.createTitleBox(" Input Model ", new NBODialogConfig.HelpBtn("model_input_intro_help.htm"));
        this.panel.add(this.inputHeader);
        this.inputComponent = this.getInputComponent();
        this.panel.add(this.inputComponent);
        this.editHeader = this.getEditHeader();
        this.panel.add(this.editHeader).setVisible(false);
        this.editComponent = this.getEditComponent();
        this.panel.add(this.editComponent).setVisible(false);
        this.saveHeader = NBODialogModel.createTitleBox(" Save Model ", new NBODialogConfig.HelpBtn("model_save_intro_help.htm"));
        this.panel.add(this.saveHeader).setVisible(false);
        this.saveComponent = this.getSaveComponent();
        this.panel.add(this.saveComponent).setVisible(false);
        this.panel.add(Box.createGlue());
        if (this.vwr.ms.ac > 0) {
            this.loadModelToNBO(null, false);
        }
        return this.panel;
    }

    private void resetVariables_m() {
        this.actionID = 0;
        this.boxCount = 0;
        this.notFromNBO = false;
    }

    private Box getEditHeader() {
        Box topBox = Box.createHorizontalBox();
        this.undo = new JButton("<HTML>&#8592Undo</HTML>");
        this.redo = new JButton("<HTML>Redo&#8594</HTML>");
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.redo.addActionListener(this.redoAction);
        this.undo.addActionListener(this.undoAction);
        topBox.add(this.undo);
        topBox.add(this.redo);
        topBox.add(new NBODialogConfig.HelpBtn("model_edit_intro_help.htm"));
        return NBODialogModel.createTitleBox(" Edit Model ", topBox);
    }

    private Component getInputComponent() {
        Box inputBox = this.createBorderBox(true);
        inputBox.setMaximumSize(new Dimension(360, 140));
        inputBox.setPreferredSize(new Dimension(360, 140));
        inputBox.setMinimumSize(new Dimension(360, 140));
        JPanel p2 = new JPanel(new GridLayout(3, 2));
        p2.setMaximumSize(new Dimension(360, 90));
        p2.setPreferredSize(new Dimension(360, 90));
        p2.setMinimumSize(new Dimension(360, 90));
        JRadioButton jrJmolIn = new JRadioButton("NIH/PubChem/PDB");
        jrJmolIn.setFont(monoFont);
        JRadioButton jrLineIn = new JRadioButton("Line Formula");
        jrLineIn.setFont(monoFont);
        jrLineIn.setSelected(true);
        JRadioButton jrFileIn = new JRadioButton("File Input");
        jrFileIn.setFont(monoFont);
        ButtonGroup rg = new ButtonGroup();
        rg.add(jrJmolIn);
        rg.add(jrLineIn);
        rg.add(jrFileIn);
        this.jtNIHInput = new JTextField();
        this.createInput(this.jtNIHInput, jrJmolIn);
        this.jtLineFormula = new JTextField();
        this.createInput(this.jtLineFormula, jrLineIn);
        this.jtNIHInput.setFont(userInputFont);
        this.jtLineFormula.setFont(userInputFont);
        this.jtLineFormula.add(new JLabel("line formula"));
        String[] useOps = new String[]{"<Select File  Type>", "[.xyz]  XYZ", "[.mol]  MOL", "[.cfi]  NBO Cartesian", "[.vfi]  NBO Valence", "[.47]   NBO Archive", "[.gau]  Gaussian Input", "[.log]  Gaussian Output", "[.gms]  GAMESS Input", "[.adf]  ADF Input", "[.jag]  Jaguar Input", "[.mm2]  MM2-Input", "[.mnd]  Dewar Type Input", "[.mp]   Molpro Input", "[.nw]   NWChem Input", "[.orc]  Orca Input", "[.pqs]  PQS Input", "[.qc]   Q-Chem Input"};
        final JComboBox<String> jComboUse = new JComboBox<String>(useOps);
        jComboUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.doComboUseAction(jComboUse.getSelectedIndex() > 0 ? jComboUse.getSelectedItem().toString() : null);
            }
        });
        p2.add(jrLineIn);
        p2.add(this.jtLineFormula);
        p2.add(jrJmolIn);
        p2.add(this.jtNIHInput);
        p2.add(jrFileIn);
        p2.add(jComboUse);
        this.addFocusListeners(jComboUse, jrFileIn);
        inputBox.add(p2);
        this.inputFileHandler = new NBOFileHandler("", "", 1, "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47", (NBODialog)((Object)this)){

            @Override
            protected boolean doFileBrowsePressed() {
                int button;
                String folder = this.tfDir.getText().trim();
                String name = this.tfName.getText();
                String ext = this.tfExt.getText();
                if (!folder.equals("")) {
                    if (!folder.contains(":")) {
                        folder = "C:/" + folder;
                    }
                    folder = folder + "/" + (name.equals("") ? "new" : name + "." + ext);
                }
                JFileChooser myChooser = new JFileChooser();
                if (this.useExt.contains(";")) {
                    myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt.split(";")));
                } else {
                    myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt));
                }
                myChooser.setFileHidingEnabled(true);
                if (!folder.equals("")) {
                    myChooser.setSelectedFile(new File(folder));
                }
                if ((button = myChooser.showDialog(this, GT._("Select"))) == 0) {
                    File newFile = myChooser.getSelectedFile();
                    if (newFile.toString().indexOf(".") < 0) {
                        NBODialogModel.this.logError("File not found");
                        return false;
                    }
                    this.jobStem = 2.getJobStem((File)newFile);
                    NBODialogModel.this.loadModelFromNBO(newFile.getParent(), this.jobStem, NBOFileHandler.getExt((File)newFile));
                    NBODialogModel.this.inputFileHandler.setInput(this.fileDir, this.jobStem, NBOFileHandler.getExt((File)newFile));
                    this.fileDir = newFile.getParent();
                    return true;
                }
                return false;
            }
        };
        this.addFocusListeners(this.inputFileHandler.tfDir, jrFileIn);
        this.addFocusListeners(this.inputFileHandler.tfExt, jrFileIn);
        this.addFocusListeners(this.inputFileHandler.tfName, jrFileIn);
        inputBox.add(this.inputFileHandler);
        inputBox.add(Box.createGlue());
        return inputBox;
    }

    protected void doComboUseAction(String item) {
        if (item == null) {
            this.inputFileHandler.tfExt.setText("");
            this.inputFileHandler.useExt = "adf;cfi;com;g09;gau;gms;jag;log;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;47";
        } else {
            item = item.substring(item.indexOf("[") + 2, item.indexOf("]"));
            this.inputFileHandler.tfExt.setText(item);
            this.inputFileHandler.useExt = item;
        }
    }

    private Box getEditComponent() {
        Box editBox = this.createBorderBox(false);
        Box actionBox = Box.createVerticalBox();
        JRadioButton[] jrModelActions = new JRadioButton[9];
        ButtonGroup rg = new ButtonGroup();
        for (int i = 0; i < 9; ++i) {
            jrModelActions[i] = new JRadioButton(MODEL_ACTIONS[i]);
            jrModelActions[i].setToolTipText(EDIT_INFO[i]);
            actionBox.add(jrModelActions[i]);
            rg.add(jrModelActions[i]);
            final int op = i;
            jrModelActions[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialogModel.this.doModelAction(op);
                }
            });
        }
        editBox.add(actionBox);
        Box rightBox = Box.createVerticalBox();
        this.createInnerEditBox();
        rightBox.add(this.innerEditBox);
        Box lowBox = Box.createHorizontalBox();
        JButton sym = new JButton(MODEL_ACTIONS[10]);
        sym.setToolTipText(EDIT_INFO[10]);
        sym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.doGetSymmetry();
            }
        });
        lowBox.add(sym);
        this.rebond = new JButton(MODEL_ACTIONS[9]);
        this.rebond.setEnabled(false);
        this.rebond.setToolTipText(EDIT_INFO[9]);
        this.rebond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.doModelAction(9);
            }
        });
        lowBox.add(this.rebond);
        rightBox.add(lowBox);
        editBox.add(rightBox);
        return editBox;
    }

    private void createInnerEditBox() {
        this.innerEditBox = Box.createVerticalBox();
        this.innerEditBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.innerEditBox.setMaximumSize(new Dimension(275, 200));
        this.innerEditBox.setAlignmentX(0.5f);
        this.innerEditBox.setVisible(false);
        Box atBox = Box.createHorizontalBox();
        this.atomsLabel = new JLabel("");
        atBox.add(this.atomsLabel);
        this.atomNumBoxes = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.atomNumBoxes[i] = new JTextField();
            this.atomNumBoxes[i].setFont(userInputFont);
            this.atomNumBoxes[i].setMaximumSize(new Dimension(50, 50));
            atBox.add(this.atomNumBoxes[i]).setVisible(false);
            final int num = i;
            this.atomNumBoxes[i].addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    NBODialogModel.this.editValueTf.setText("");
                    NBODialogModel.this.editValueTf.setEnabled(NBODialogModel.this.modelEditGetSelected().length() > 0);
                }
            });
            this.atomNumBoxes[i].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    NBODialogModel.this.doAtomNumBoxFocus(true, num);
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    NBODialogModel.this.doAtomNumBoxFocus(false, 0);
                }
            });
            this.atomNumBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialogModel.this.doSetAtomBoxesFromSelection(null);
                }
            });
        }
        this.innerEditBox.add(atBox);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Symmetry Type: "));
        this.jcSymOps = new JComboBox();
        this.jcSymOps.addItem("<Select Transition Metal>");
        this.jcSymOps.setMaximumSize(new Dimension(180, 40));
        this.jcSymOps.setEnabled(false);
        box.add(this.jcSymOps);
        box.setVisible(false);
        this.innerEditBox.add(box);
        this.currVal = new JTextField("pick atoms...");
        this.currVal.setFont(titleFont);
        this.currVal.setBackground(new Color(220, 220, 220));
        this.currVal.setMinimumSize(new Dimension(250, 40));
        this.currVal.setPreferredSize(new Dimension(250, 40));
        this.currVal.setMaximumSize(new Dimension(250, 40));
        this.currVal.setHorizontalAlignment(0);
        this.innerEditBox.add(this.currVal).setVisible(false);
        this.valueLabel = new JLabel();
        this.valueLabel.setAlignmentX(0.5f);
        this.innerEditBox.add(this.valueLabel).setVisible(false);
        this.editValueTf = new JTextField("Select atoms...");
        this.editValueTf.setVisible(false);
        this.editValueTf.setMaximumSize(new Dimension(200, 30));
        this.editValueTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.doEditValueTextField();
            }
        });
        this.editValueTf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                if (!NBODialogModel.this.editValueTf.getText().equals("") && !NBODialogModel.this.editValueTf.getText().contains("Select")) {
                    NBODialogModel.this.jbApply.setEnabled(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (NBODialogModel.this.editValueTf.getText().equals("")) {
                    NBODialogModel.this.jbApply.setEnabled(false);
                }
            }
        });
        this.innerEditBox.add(this.editValueTf).setVisible(false);
        Box lowBox = Box.createHorizontalBox();
        this.jbClear = new JButton("Clear Selected");
        this.jbClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.clearSelected(true);
            }
        });
        this.jbApply = new JButton("Apply");
        this.jbApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.doApply();
            }
        });
        lowBox.add(this.jbClear).setVisible(false);
        lowBox.add(this.jbApply).setVisible(false);
        this.innerEditBox.add(lowBox);
    }

    protected void doAtomNumBoxFocus(boolean isGained, int num) {
        if (!isGained) {
            int atnum = PT.parseInt(this.atomNumBoxes[num].getText());
            if (atnum > this.vwr.ms.ac || atnum < 1) {
                this.atomNumBoxes[num].setText("");
            } else {
                this.doSetAtomBoxesFromSelection(null);
            }
        } else if (num == this.boxCount - 1) {
            this.jbApply.setEnabled(this.modelEditGetSelected().length() > 0);
        }
    }

    protected void doApply() {
        this.postActionToNBO_m(this.actionID);
    }

    protected void doEditValueTextField() {
        this.postActionToNBO_m(this.actionID);
    }

    protected void updateSelected(boolean doPost) {
        String selected = this.modelEditGetSelected();
        String script = "measure delete;";
        int cnt = selected.split(" ").length;
        this.editValueTf.setEnabled(cnt > 0);
        this.editValueTf.setText("");
        this.editValueTf.requestFocus();
        block0 : switch (this.boxCount) {
            case 4: {
                String desc = "";
                if (cnt > 1) {
                    script = script + "measure " + selected + " \" \";";
                }
                switch (cnt) {
                    case 0: {
                        this.currVal.setText("pick atoms...");
                        break;
                    }
                    case 1: {
                        desc = this.actionID == 0 ? "atomic number or symbol" : "atomic number";
                        break;
                    }
                    case 2: {
                        desc = "distance";
                        break;
                    }
                    case 3: 
                    case 4: {
                        desc = cnt == 3 ? "angle" : "dihedral angle";
                    }
                }
                this.valueLabel.setText("(" + desc + ")");
                this.valueLabel.setVisible(cnt > 0);
                break;
            }
            case 2: {
                if (cnt != 2) break;
                this.jbApply.setEnabled(true);
                if (this.editValueTf.isVisible()) {
                    this.editValueTf.requestFocus();
                    break;
                }
                this.atomNumBoxes[1].requestFocus();
                break;
            }
            case 1: {
                if (cnt != 1 || this.actionID != 9) break;
                this.jcSymOps.removeAllItems();
                this.jcSymOps.setEnabled(true);
                int atomInd = Integer.parseInt(this.atomNumBoxes[0].getText()) - 1;
                int val = this.vwr.ms.at[atomInd].getValence();
                this.jbApply.setEnabled(true);
                switch (val) {
                    case 4: {
                        for (String x : new String[]{"td", "c3vi", "c4v"}) {
                            this.jcSymOps.addItem(x);
                        }
                        break block0;
                    }
                    case 5: {
                        for (String x : new String[]{"c4vo", "c4vi"}) {
                            this.jcSymOps.addItem(x);
                        }
                        break block0;
                    }
                    case 6: {
                        for (String x : new String[]{"c3vo", "c3vi", "c5vo", "c5vi"}) {
                            this.jcSymOps.addItem(x);
                        }
                        break block0;
                    }
                    default: {
                        this.jcSymOps.addItem("<Select Transition Metal>");
                        this.jcSymOps.setEnabled(false);
                        this.jbApply.setEnabled(false);
                    }
                }
            }
        }
        if (this.actionID == 0) {
            this.postActionToNBO_m(7);
        }
        this.runScriptQueued(script);
        this.editValueTf.setText("");
        this.editValueTf.setEnabled(selected.length() > 0);
        this.showSelected(selected);
        if (this.actionID == 7 || doPost) {
            this.postActionToNBO_m(this.actionID);
        }
    }

    protected String modelEditGetSelected() {
        String s = "";
        for (int j = 0; j < this.boxCount; ++j) {
            s = s + this.atomNumBoxes[j].getText().trim() + " ";
        }
        return PT.rep(s.trim(), "  ", " ").trim();
    }

    private Box getSaveComponent() {
        Box sBox = this.createBorderBox(true);
        String[] SAVE_OPTIONS = new String[]{"<Select File Type>", "XYZ                        [.xyz]", "MOL                        [.mol]", "NBO Cartesian              [.cfi]", "NBO Valence                [.vfi]", "Gaussian Input             [.gau]", "Gaussian Input (Cartesian) [.gau]", "Gaussian Input (z-Matrix)  [.gau]", "GAMESS Input               [.gms]", "ADF Input                  [.adf]", "Jaguar Input               [.jag]", "MM2-Input                  [.mm2]", "Dewar Type Input           [.mnd]", "Molpro Input               [.mp]", "NWChem Input               [.nw]", "Orca Input                 [.orc]", "PQS Input                  [.pqs]", "Q-Chem Input               [.qc]"};
        this.jComboSave = new JComboBox<String>(SAVE_OPTIONS);
        this.jComboSave.setFont(monoFont);
        this.saveFileHandler = new NBOFileHandler("", "", 5, "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com", (NBODialog)((Object)this)){

            @Override
            protected boolean doFileBrowsePressed() {
                String folder = this.tfDir.getText().trim();
                String name = this.tfName.getText().trim();
                String ext = this.tfExt.getText().trim();
                if (!(ext.equals("") || folder.equals("") || name.equals(""))) {
                    File f = new File(folder + "/" + name + "." + ext);
                    if (!PT.isOneOf(ext, "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com")) {
                        NBODialogModel.this.alertError("Invalid output extenstion");
                        return false;
                    }
                    if (f.exists()) {
                        int i = JOptionPane.showConfirmDialog(null, "File " + f + " already exists, do you want to overwrite contents?", "Warning", 0);
                        if (i == 1) {
                            return false;
                        }
                        this.dialog.inputFileHandler.setInput(folder, name, ext);
                    }
                    NBODialogModel.this.saveModel(folder, name, ext);
                    NBODialogModel.this.saveWorkingPath(this.fileDir);
                    return true;
                }
                JFileChooser myChooser = new JFileChooser();
                this.useExt = ext.equals("") ? "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com" : ext;
                myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt.split(",")));
                myChooser.setFileHidingEnabled(true);
                String savePath = this.fileDir;
                if (!folder.equals("")) {
                    if (!folder.contains(":")) {
                        folder = "C:/" + folder;
                    }
                } else {
                    folder = new File(this.fileDir).getParent();
                }
                savePath = name.equals("") && this.jobStem != null ? this.tfDir.getText() + "/" + (this.jobStem.equals("") ? "new.cfi" : this.jobStem + (ext.contains(";") ? "" : "." + ext)) : this.tfDir.getText() + "/" + name + "." + ext;
                myChooser.setSelectedFile(new File(savePath));
                int button = myChooser.showSaveDialog(this);
                if (button == 0) {
                    File newFile = myChooser.getSelectedFile();
                    ext = NBOFileHandler.getExt((File)newFile);
                    if (PT.isOneOf(NBOFileHandler.getExt((File)newFile), "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com")) {
                        int i;
                        if (newFile.exists() && (i = JOptionPane.showConfirmDialog(null, "File " + newFile + " already exists, do you want to overwrite contents?", "Warning", 0)) == 1) {
                            return false;
                        }
                        this.dialog.inputFileHandler.setInput(folder, name, ext);
                        this.fileDir = newFile.getParent();
                        NBODialogModel.this.saveModel(newFile.getParent(), NBOFileHandler.getJobStem((File)newFile), ext);
                        NBODialogModel.this.saveWorkingPath(this.fileDir);
                    } else {
                        NBODialogModel.this.logError("Invalid extension defined");
                    }
                }
                return false;
            }
        };
        this.jComboSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBODialogModel.this.jComboSave.getSelectedIndex() > 0) {
                    NBODialogModel.this.doComboSaveAction(NBODialogModel.this.jComboSave.getSelectedItem().toString());
                }
            }
        });
        sBox.add(this.jComboSave);
        sBox.add(this.saveFileHandler);
        return sBox;
    }

    protected void doComboSaveAction(String item) {
        String ext = item.substring(item.indexOf("[") + 2, item.indexOf("]"));
        this.saveFileHandler.tfExt.setText(ext);
    }

    protected void showSelected(String s) {
        BS bs = new BS();
        for (String x : PT.getTokens(s)) {
            bs.set(Integer.parseInt(x) - 1);
        }
        String script = "select on " + bs + ";";
        this.runScriptQueued(script);
    }

    private void createInput(final JTextField field, JRadioButton radio) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogModel.this.doLoadtModelFromTextBox(field);
            }
        });
        this.addFocusListeners(field, radio);
    }

    private void addFocusListeners(final JComponent field, final JRadioButton radio) {
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                radio.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        radio.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                field.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    protected void doModelAction(int action) {
        this.actionID = action;
        this.runScriptQueued("set refreshing true; measurements delete");
        this.clearSelected(true);
        switch (action) {
            case 4: {
                this.boxCount = 1;
                this.setEditBox("Radical name or line formula...");
                break;
            }
            case 9: {
                this.boxCount = 1;
                this.setEditBox(null);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                this.boxCount = 2;
                this.setEditBox(null);
                break;
            }
            case 0: 
            case 6: 
            case 7: {
                this.boxCount = 4;
                this.setEditBox(null);
            }
        }
    }

    private void setEditBox(String label) {
        if (label == null) {
            label = "Select atom" + (this.boxCount > 1 ? "s" : "") + "...";
        }
        this.jbApply.setEnabled(false);
        for (int i = 0; i < 4; ++i) {
            this.atomNumBoxes[i].setVisible(i < this.boxCount);
        }
        this.atomsLabel.setText(this.boxCount == 0 ? "" : "Atom" + (this.boxCount > 1 ? "s" : "") + ":");
        this.editValueTf.setText(label);
        this.editValueTf.setEnabled(false);
        this.jcSymOps.getParent().setVisible(this.actionID == 9);
        switch (this.actionID) {
            case 0: 
            case 4: 
            case 6: 
            case 8: {
                this.editValueTf.setVisible(true);
                break;
            }
            default: {
                this.editValueTf.setVisible(false);
            }
        }
        this.currVal.setVisible(this.boxCount == 4);
        this.valueLabel.setVisible(true);
        this.jbApply.setVisible(this.actionID != 7);
        this.jbClear.setVisible(true);
        this.innerEditBox.repaint();
        this.innerEditBox.revalidate();
    }

    protected void clearSelected(boolean andShow) {
        for (int i = 0; i < this.boxCount; ++i) {
            System.out.println("clearing all boxes");
            this.atomNumBoxes[i].setText("");
        }
        if (this.currVal != null) {
            this.currVal.setText("");
        }
        if (this.valueLabel != null) {
            this.valueLabel.setText(" ");
        }
        if (this.editValueTf != null) {
            this.editValueTf.setText("Select atoms...");
            this.editValueTf.setEnabled(false);
            this.jbApply.setEnabled(false);
        }
        if (andShow) {
            this.updateSelected(false);
        }
    }

    protected void postActionToNBO_m(int actionID) {
        SB sb = new SB();
        String selected = this.modelEditGetSelected();
        String cmd = MODEL_ACTIONS[actionID].toLowerCase() + " " + selected + " ";
        String val = this.editValueTf.getText().trim();
        if (actionID == 0 && PT.parseInt(val) == Integer.MIN_VALUE) {
            if (val.length() == 0) {
                return;
            }
            val = "" + Elements.elementNumberFromSymbol(val, true);
        }
        if (this.boxCount == 4 || this.boxCount == 1) {
            cmd = cmd + val;
        } else if (actionID == 8) {
            if (!val.startsWith(":")) {
                cmd = cmd + ":";
            }
            cmd = cmd + val;
        }
        if (actionID == 9) {
            cmd = cmd + this.jcSymOps.getSelectedItem().toString();
        }
        this.runScriptNow("save orientation o2");
        this.postAddCmd(sb, cmd);
        this.logCmd(cmd);
        this.jbApply.setEnabled(false);
        if (actionID == 7) {
            this.postNBO_m(sb, 81, "Checking Value", null, null);
        } else {
            this.postNBO_m(sb, actionID == 0 ? 11 : 21, "Editing model", null, null);
            this.resetOnAtomClick = true;
        }
    }

    protected void doGetSymmetry() {
        String cmd = "symmetry";
        this.logCmd(cmd);
        this.postNBO_m(this.postAddCmd(new SB(), cmd), 51, "Checking Symmetry", null, null);
    }

    protected void doLoadtModelFromTextBox(JTextField textBox) {
        String model = textBox.getText().trim();
        if (model.length() == 0) {
            return;
        }
        String s = "";
        this.inputFileHandler.setInput(null, "", "");
        this.saveFileHandler.setInput(null, "", "");
        this.clearSelected(false);
        if (textBox == this.jtNIHInput) {
            this.modelOrigin = 1;
            this.notFromNBO = true;
            if ("$:=".indexOf(model.charAt(0)) < 0) {
                model = "$" + model;
            }
            if (model.startsWith("=")) {
                switch (model.length()) {
                    case 5: {
                        break;
                    }
                    case 4: {
                        model = "=" + model;
                        break;
                    }
                    default: {
                        if (model.indexOf("/") >= 0) break;
                        this.logError("PDB codes must be of the form XXX for ligands and XXXX for standard PDB entries.");
                    }
                }
            }
            this.jtLineFormula.setText("");
            this.saveFileHandler.setInput(null, model, "mol");
            this.logCmd("get " + model);
            if (this.loadModelFileNow(model) == null) {
                if ((model = (model.charAt(0) == ':' ? "$" : ":") + model.substring(1)).startsWith("$=")) {
                    this.logError("RCSB does not recognize ligand code " + model.substring(2) + ".");
                    return;
                }
                this.logCmd("get " + model);
                if (this.loadModelFileNow(model) == null) {
                    this.logError("Neither NIH/CIR nor PubChem have recognize this identifier.");
                    this.notFromNBO = false;
                }
            }
        } else {
            this.modelOrigin = 2;
            SB sb = new SB();
            this.jtNIHInput.setText("");
            s = "show " + model;
            this.saveFileHandler.setInput(null, "line", "mol");
            this.postAddCmd(sb, s);
            this.logCmd(s);
            this.postNBO_m(sb, 31, "model from line input...", null, null);
        }
    }

    protected void loadModelToNBO(String s, boolean undoRedo) {
        boolean alsoLoadJmol = true;
        if (s == null) {
            s = this.runScriptNow(";print data({*},'cfi');");
            alsoLoadJmol = false;
        }
        if (undoRedo) {
            this.runScriptNow("save orientation o2");
        }
        SB sb = new SB();
        this.postAddGlobalC(sb, "PATH", this.nboService.getServerPath(null) + "/");
        this.postAddGlobalC(sb, "ESS", "c");
        this.postAddGlobalC(sb, "FNAME", "jmol_outfile");
        this.postAddGlobalC(sb, "IN_EXT", "cfi");
        this.postAddCmd(sb, "use");
        this.postNBO_m(sb, undoRedo ? 71 : 61, (alsoLoadJmol ? "Loading" : "Sending") + " model to NB", "jmol_outfile.cfi", s);
    }

    protected void loadModelFromNBO(String path, String fname, String ext) {
        if (PT.isOneOf(ext, "xyz;mol")) {
            this.notFromNBO = true;
            this.runScriptNow("set refreshing false");
            this.loadModelFileQueued(new File(path + "\\" + fname + "." + ext), false);
            return;
        }
        String ess = this.getEss(ext, true);
        SB sb = new SB();
        if (this.jtNIHInput != null) {
            this.jtNIHInput.setText("");
            this.jtLineFormula.setText("");
        }
        this.modelOrigin = 3;
        this.postAddGlobalC(sb, "PATH", path);
        this.postAddGlobalC(sb, "ESS", ess);
        this.postAddGlobalC(sb, "FNAME", fname);
        this.postAddGlobalC(sb, "IN_EXT", ext.toLowerCase());
        this.postAddCmd(sb, "use");
        this.clearSelected(false);
        this.logCmd("use." + ess + " " + fname + "." + ext);
        this.postNBO_m(sb, 31, "Loading model from NBO...", null, null);
    }

    protected void saveModel(String path, String fname, String ext) {
        if (PT.isOneOf(ext, "xyz;mol")) {
            String s = this.vwr.getModelExtract("1.1", false, false, ext.toUpperCase());
            String ret = this.vwr.writeTextFile(path + "\\" + fname + "." + ext, s);
            this.logValue(ret);
            return;
        }
        String ess = this.getEss(ext, false);
        SB sb = new SB();
        this.postAddGlobalC(sb, "PATH", path);
        this.postAddGlobalC(sb, "ESS", ess);
        this.postAddGlobalC(sb, "FNAME", fname);
        this.postAddGlobalC(sb, "OUT_EXT", ext.toLowerCase());
        this.postAddCmd(sb, "save");
        this.postNBO_m(sb, 41, "Saving model...", null, null);
        this.logCmd("save." + ess + " " + fname);
        this.logValue("--Model Saved--<br>" + path + "\\" + fname + "." + ext);
    }

    private String getEss(String ext, boolean isLoading) {
        if (((ext = ext.toLowerCase()).equals("gau") || ext.equals("g09") || ext.equals("com")) && !isLoading) {
            if (this.jComboSave.getSelectedItem().toString().contains("(C")) {
                return ext.charAt(0) + "c";
            }
            if (this.jComboSave.getSelectedItem().toString().contains("(z")) {
                return ext.charAt(0) + "z";
            }
            return "g";
        }
        if (ext.equals("cfi") || ext.equals("vfi") || ext.equals("gau") || ext.equals("log") || ext.equals("g09")) {
            return "" + ext.charAt(0);
        }
        if (ext.equals("47")) {
            return "a";
        }
        if (ext.equals("mm2")) {
            return "mm";
        }
        if (ext.equals("com")) {
            return "g";
        }
        return ext;
    }

    protected void notifyPick_m(String atomno) {
        boolean isSelected;
        this.runScriptNow("measure delete;" + (this.resetOnAtomClick ? "select none" : ""));
        if (this.resetOnAtomClick) {
            this.clearSelected(false);
        }
        this.resetOnAtomClick = false;
        if (this.boxCount == 0) {
            return;
        }
        String[] tok = atomno.split(",");
        String selected = " " + this.modelEditGetSelected() + " ";
        if (tok.length > 1) {
            if (this.boxCount == 2) {
                this.clearSelected(true);
            }
            String[] tok2 = tok[1].split(" ");
            String at1 = tok2[2].replaceAll("[\\D]", "");
            if (!selected.contains(" " + at1 + " ")) {
                this.notifyPick_m(at1);
            }
            String at2 = tok2[5].replaceAll("[\\D]", "");
            if (!selected.contains(" " + at2 + " ")) {
                this.notifyPick_m(at2);
            }
            return;
        }
        boolean bl = isSelected = this.vwr.evaluateExpressionAsVariable("{*}[" + atomno + "].selected").asFloat() == 1.0f;
        if (isSelected) {
            selected = PT.rep(selected, " " + atomno + " ", " ").trim();
        } else {
            if (PT.getTokens(selected).length >= this.boxCount) {
                this.clearSelected(true);
                selected = "";
            }
            selected = selected + " " + atomno;
        }
        this.doSetAtomBoxesFromSelection(selected);
    }

    protected void doSetAtomBoxesFromSelection(String selected) {
        if (selected == null) {
            selected = this.modelEditGetSelected();
        }
        String[] split = PT.getTokens(selected);
        System.out.println("setting " + selected);
        for (int i = 0; i < this.atomNumBoxes.length; ++i) {
            this.atomNumBoxes[i].setText(i >= split.length ? "" : "  " + split[i]);
            System.out.println("set  i=" + i + " " + this.atomNumBoxes[i].getText());
        }
        this.updateSelected(false);
    }

    private void setCurrentValue(String sval) {
        this.currVal.setText(sval.length() == 0 ? "pick atoms..." : "current value: " + sval);
    }

    protected void notifyLoad_m() {
        String fileContents = this.runScriptNow("print data({*},'cfi')");
        if (this.notFromNBO) {
            this.notFromNBO = false;
            this.loadModelToNBO(fileContents, false);
            return;
        }
        this.runScriptNow(";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;;select within(model,visible);rotate best;");
        this.doSetStructure(null);
        this.showComponents(true);
        this.innerEditBox.setVisible(true);
        if (this.vwr.ms.ac > 0 && fileContents != null) {
            this.undoStack.push(fileContents);
            if (this.undoStack.size() > 5) {
                this.undoStack.removeElementAt(0);
            }
        }
        this.undo.setEnabled(this.undoStack.size() > 1);
        this.redo.setEnabled(!this.redoStack.isEmpty());
        this.rebond.setEnabled(((String)this.vwr.evaluateExpression("{transitionMetal}")).length() > 4);
        if (this.actionID == 4) {
            this.doModelAction(this.actionID);
        }
        this.runScriptNow("select none; select on;refresh");
    }

    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(null, st, "Warning", 0);
        if (i == 0) {
            this.saveModel(newFile.getParent(), NBOFileHandler.getJobStem((File)newFile), ext);
        }
    }

    protected static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    private void postNBO_m(SB sb, final int mode, String statusMessage, String fileName, String fileData) {
        final NBORequest req = new NBORequest();
        req.set(new Runnable(){

            @Override
            public void run() {
                NBODialogModel.this.processNBO_m(mode, req);
            }
        }, statusMessage, new String[]{"m_cmd.txt", sb.toString(), fileName, fileData});
        this.nboService.postToNBO(req);
    }

    protected void processNBO_m(int mode, NBORequest req) {
        String[] a = req.getReplyLines();
        if (a[0].indexOf("DATA") >= 0) {
            a[0] = a[0] + " NBO";
        }
        String s = PT.join(a, '\n', 0);
        switch (mode) {
            case 11: {
                this.runScriptQueued("z = show('zoom');set refreshing false;x = {*}.xyz.all;load " + s + ";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";compare {*} @x rotate translate 0;script inline @z;set refreshing true");
                break;
            }
            case 21: 
            case 31: {
                s = s + ";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;";
                s = mode == 21 ? "set refreshing off;save orientation o4;load " + s + ";restore orientation o4;set refreshing on" : ";load " + s;
                this.loadModelDataQueued(s);
                break;
            }
            case 41: {
                break;
            }
            case 51: {
                String symmetry = s.substring(0, s.indexOf("\n"));
                this.logValue(symmetry);
                s = PT.rep(s.substring(s.indexOf("\n") + 1), "\"\n", "\" NBO\n");
                s = "set refreshing false;load " + s + ";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";set refreshing true";
                this.loadModelDataQueued(s);
                break;
            }
            case 61: {
                s = "load " + s + ";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";set refreshing true;";
                this.loadModelDataQueued(s);
                break;
            }
            case 71: {
                this.loadModelDataQueued("set refreshing false;load " + s + ";set fontscaling true; select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";restore orientation o2;set refreshing true");
                break;
            }
            case 81: {
                String sval = a[0].trim();
                this.logValue(sval);
                this.setCurrentValue(sval);
            }
        }
    }
}

