/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Map;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetLabel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.GBC;

public class PresetListPanel
extends JPanel {
    public PresetListPanel() {
        super(new GridBagLayout());
    }

    public void updatePresets(Collection<TaggingPresetType> collection, Map<String, String> map, TaggingPresetHandler taggingPresetHandler) {
        this.removeAll();
        if (collection.isEmpty()) {
            this.setVisible(false);
            return;
        }
        for (Cloneable cloneable : TaggingPresets.getMatchingPresets(collection, map, true)) {
            TaggingPresetLabel taggingPresetLabel = new TaggingPresetLabel((TaggingPreset)cloneable);
            taggingPresetLabel.addMouseListener(new LabelMouseAdapter((TaggingPreset)cloneable, taggingPresetHandler));
            this.add((Component)taggingPresetLabel, GBC.eol().fill(2));
        }
        if (this.getComponentCount() > 0) {
            Cloneable cloneable;
            this.setVisible(true);
            int n = this.getComponentCount() * this.getComponent(0).getHeight();
            cloneable = new Dimension(this.getWidth(), n);
            this.setMaximumSize((Dimension)cloneable);
            this.setMinimumSize((Dimension)cloneable);
        } else {
            this.setVisible(false);
        }
    }

    static final class LabelMouseAdapter
    extends MouseAdapter {
        private final TaggingPreset t;
        private final TaggingPresetHandler presetHandler;

        LabelMouseAdapter(TaggingPreset taggingPreset, TaggingPresetHandler taggingPresetHandler) {
            this.t = taggingPreset;
            this.presetHandler = taggingPresetHandler;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Collection<OsmPrimitive> collection = this.t.createSelection(this.presetHandler.getSelection());
            if (collection.isEmpty()) {
                return;
            }
            int n = this.t.showDialog(collection, false);
            if (n == 1) {
                this.presetHandler.updateTags(this.t.getChangedTags());
            }
        }
    }
}

