/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyDSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 6351851846414049890L;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public PKeyDSA allocate(Ruby runtime, RubyClass klass) {
            return new PKeyDSA(runtime, klass);
        }
    };
    private volatile DSAPublicKey publicKey;
    private volatile transient DSAPrivateKey privateKey;
    private volatile transient BigInteger dsa_x;
    private volatile transient BigInteger dsa_y;
    private volatile transient BigInteger dsa_p;
    private volatile transient BigInteger dsa_q;
    private volatile transient BigInteger dsa_g;
    private static final int SPEC_X = 0;
    private static final int SPEC_Y = 1;
    private static final int SPEC_P = 2;
    private static final int SPEC_Q = 3;
    private static final int SPEC_G = 4;

    public static void createPKeyDSA(Ruby runtime, RubyModule PKey2, RubyClass PKeyPKey) {
        RubyClass DSA = PKey2.defineClassUnder("DSA", PKeyPKey, ALLOCATOR);
        RubyClass PKeyError = PKey2.getClass("PKeyError");
        PKey2.defineClassUnder("DSAError", PKeyError, PKeyError.getAllocator());
        DSA.defineAnnotatedMethods(PKeyDSA.class);
    }

    static RubyClass _DSA(Ruby runtime) {
        return PKeyDSA._PKey(runtime).getClass("DSA");
    }

    public PKeyDSA(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public PKeyDSA(Ruby runtime, RubyClass type, DSAPrivateKey privKey, DSAPublicKey pubKey) {
        super(runtime, type);
        this.privateKey = privKey;
        this.publicKey = pubKey;
    }

    PKeyDSA(Ruby runtime, DSAPublicKey pubKey) {
        this(runtime, PKeyDSA._DSA(runtime), null, pubKey);
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @JRubyMethod(name={"generate"}, meta=true)
    public static IRubyObject generate(IRubyObject self, IRubyObject arg) {
        int keysize = RubyNumeric.fix2int((IRubyObject)arg);
        PKeyDSA dsa = new PKeyDSA(self.getRuntime(), (RubyClass)self);
        PKeyDSA.dsaGenerate(dsa, keysize);
        return dsa;
    }

    private static void dsaGenerate(PKeyDSA dsa, int keysize) throws RaiseException {
        try {
            KeyPairGenerator gen = SecurityHelper.getKeyPairGenerator("DSA");
            gen.initialize(keysize, new SecureRandom());
            KeyPair pair = gen.generateKeyPair();
            dsa.privateKey = (DSAPrivateKey)pair.getPrivate();
            dsa.publicKey = (DSAPublicKey)pair.getPublic();
        }
        catch (NoSuchAlgorithmException e) {
            throw PKeyDSA.newDSAError(dsa.getRuntime(), e.getMessage());
        }
        catch (RuntimeException e) {
            throw PKeyDSA.newDSAError(dsa.getRuntime(), e.getMessage(), e);
        }
    }

    static PKeyDSA newInstance(Ruby runtime, PublicKey publicKey) {
        return new PKeyDSA(runtime, (DSAPublicKey)publicKey);
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        KeyFactory dsaFactory;
        Ruby runtime = context2.runtime;
        if (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2) == 0) {
            this.privateKey = null;
            this.publicKey = null;
            return this;
        }
        IRubyObject arg = args[0];
        IRubyObject pass = null;
        if (args.length > 1) {
            pass = args[1];
        }
        if (arg instanceof RubyFixnum) {
            int keysize = RubyNumeric.fix2int((RubyFixnum)((RubyFixnum)arg));
            PKeyDSA.dsaGenerate(this, keysize);
            return this;
        }
        char[] passwd = PKeyDSA.password(pass);
        RubyString str = PKeyDSA.readInitArg(context2, arg);
        String strJava = str.toString();
        Object key = null;
        try {
            dsaFactory = SecurityHelper.getKeyFactory("DSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (DSA)");
        }
        catch (RuntimeException e) {
            throw runtime.newRuntimeError("unsupported key algorithm (DSA) " + e);
        }
        boolean noClassDef = false;
        if (key == null && !noClassDef) {
            try {
                key = PKeyDSA.readPrivateKey(strJava, passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (PEMInputOutput.PasswordRequiredException retry) {
                if (PKeyDSA.ttySTDIN(context2)) {
                    try {
                        key = PKeyDSA.readPrivateKey(strJava, PKeyDSA.passwordPrompt(context2));
                    }
                    catch (Exception e) {
                        OpenSSL.debugStackTrace(runtime, e);
                    }
                }
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readDSAPublicKey(new StringReader(strJava), passwd);
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PEMInputOutput.readDSAPubKey(new StringReader(strJava));
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (Exception e) {
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readDSAPrivateKey(dsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSL.debug(runtime, "PKeyDSA could not read private key", e);
            }
            catch (IOException e) {
                OpenSSL.debug(runtime, "PKeyDSA could not read private key", e);
            }
            catch (RuntimeException e) {
                if (PKeyDSA.isKeyGenerationFailure(e)) {
                    OpenSSL.debug(runtime, "PKeyDSA could not read private key", e);
                }
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null && !noClassDef) {
            try {
                key = PKey.readDSAPublicKey(dsaFactory, str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                noClassDef = true;
                OpenSSL.debugStackTrace(runtime, e);
            }
            catch (InvalidKeySpecException e) {
                OpenSSL.debug(runtime, "PKeyDSA could not read public key", e);
            }
            catch (IOException e) {
                OpenSSL.debug(runtime, "PKeyDSA could not read public key", e);
            }
            catch (RuntimeException e) {
                if (PKeyDSA.isKeyGenerationFailure(e)) {
                    OpenSSL.debug(runtime, "PKeyDSA could not read public key", e);
                }
                OpenSSL.debugStackTrace(runtime, e);
            }
        }
        if (key == null) {
            key = this.tryPKCS8EncodedKey(runtime, dsaFactory, str.getBytes());
        }
        if (key == null) {
            key = this.tryX509EncodedKey(runtime, dsaFactory, str.getBytes());
        }
        if (key == null) {
            throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key:");
        }
        if (key instanceof KeyPair) {
            PublicKey pubKey = ((KeyPair)key).getPublic();
            PrivateKey privKey = ((KeyPair)key).getPrivate();
            if (!(privKey instanceof DSAPrivateKey)) {
                if (privKey == null) {
                    throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key: (private key is null)");
                }
                throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key: (invalid key type " + privKey.getClass().getName() + ")");
            }
            this.privateKey = (DSAPrivateKey)privKey;
            this.publicKey = (DSAPublicKey)pubKey;
        } else if (key instanceof DSAPrivateKey) {
            this.privateKey = (DSAPrivateKey)key;
        } else if (key instanceof DSAPublicKey) {
            this.publicKey = (DSAPublicKey)key;
            this.privateKey = null;
        } else {
            throw PKeyDSA.newDSAError(runtime, "Neither PUB key nor PRIV key: " + key.getClass().getName());
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.publicKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"})
    public RubyBoolean private_p() {
        return this.privateKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"to_der"})
    public RubyString to_der() {
        byte[] bytes;
        try {
            bytes = PKey.toDerDSAKey(this.publicKey, this.privateKey);
        }
        catch (NoClassDefFoundError e) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSL.bcExceptionMessage(e));
        }
        catch (IOException e) {
            throw PKeyDSA.newDSAError(this.getRuntime(), e.getMessage(), e);
        }
        return StringHelper.newString(this.getRuntime(), bytes);
    }

    @JRubyMethod
    public RubyString to_text() {
        StringBuilder result = new StringBuilder();
        if (this.privateKey != null) {
            int len = this.privateKey.getParams().getP().bitLength();
            result.append("Private-Key: (").append(len).append(" bit)").append("\n");
            result.append("priv:");
            PKeyDSA.addSplittedAndFormatted(result, this.privateKey.getX());
        }
        result.append("pub:");
        PKeyDSA.addSplittedAndFormatted(result, this.publicKey.getY());
        result.append("P:");
        PKeyDSA.addSplittedAndFormatted(result, this.publicKey.getParams().getP());
        result.append("Q:");
        PKeyDSA.addSplittedAndFormatted(result, this.publicKey.getParams().getQ());
        result.append("G:");
        PKeyDSA.addSplittedAndFormatted(result, this.publicKey.getParams().getG());
        return RubyString.newString((Ruby)this.getRuntime(), (CharSequence)result);
    }

    @JRubyMethod
    public PKeyDSA public_key() {
        return new PKeyDSA(this.getRuntime(), this.publicKey);
    }

    @Override
    @JRubyMethod(name={"to_pem", "to_s"}, alias={"export"}, rest=true)
    public RubyString to_pem(IRubyObject[] args) {
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2);
        CipherSpec spec = null;
        char[] passwd = null;
        if (args.length > 0) {
            spec = PKeyDSA.cipherSpec(args[0]);
            if (args.length > 1) {
                passwd = PKeyDSA.password(args[1]);
            }
        }
        try {
            StringWriter writer = new StringWriter();
            if (this.privateKey != null) {
                PEMInputOutput.writeDSAPrivateKey(writer, this.privateKey, spec, passwd);
            } else {
                PEMInputOutput.writeDSAPublicKey(writer, this.publicKey);
            }
            return RubyString.newString((Ruby)this.getRuntime(), (CharSequence)writer.getBuffer());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyDSA.newDSAError(this.getRuntime(), OpenSSL.bcExceptionMessage(ncdfe));
        }
        catch (IOException e) {
            throw PKeyDSA.newDSAError(this.getRuntime(), e.getMessage(), e);
        }
    }

    @JRubyMethod
    public IRubyObject syssign(IRubyObject arg) {
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject sysverify(IRubyObject arg, IRubyObject arg2) {
        return this.getRuntime().getNil();
    }

    private DSAKey getDsaKey() {
        DSAPublicKey result = this.publicKey;
        return result != null ? result : this.privateKey;
    }

    private IRubyObject toBN(BigInteger value2) {
        return value2 == null ? this.getRuntime().getNil() : BN.newBN(this.getRuntime(), value2);
    }

    private synchronized BigInteger getP() {
        DSAKey key = this.getDsaKey();
        if (key != null) {
            return key.getParams().getP();
        }
        return this.dsa_p;
    }

    @JRubyMethod(name={"p"})
    public IRubyObject get_p() {
        return this.toBN(this.getP());
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(IRubyObject p) {
        return this.setKeySpecComponent(2, p);
    }

    private synchronized BigInteger getQ() {
        DSAKey key = this.getDsaKey();
        if (key != null) {
            return key.getParams().getQ();
        }
        return this.dsa_q;
    }

    @JRubyMethod(name={"q"})
    public IRubyObject get_q() {
        return this.toBN(this.getQ());
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(IRubyObject q) {
        return this.setKeySpecComponent(3, q);
    }

    private synchronized BigInteger getG() {
        DSAKey key = this.getDsaKey();
        if (key != null) {
            return key.getParams().getG();
        }
        return this.dsa_g;
    }

    @JRubyMethod(name={"g"})
    public IRubyObject get_g() {
        return this.toBN(this.getG());
    }

    @JRubyMethod(name={"g="})
    public synchronized IRubyObject set_g(IRubyObject g) {
        return this.setKeySpecComponent(4, g);
    }

    @JRubyMethod(name={"priv_key"})
    public synchronized IRubyObject get_priv_key() {
        DSAPrivateKey key = this.privateKey;
        if (key != null) {
            return this.toBN(key.getX());
        }
        return this.toBN(this.dsa_x);
    }

    @JRubyMethod(name={"priv_key="})
    public synchronized IRubyObject set_priv_key(IRubyObject priv_key2) {
        return this.setKeySpecComponent(0, priv_key2);
    }

    @JRubyMethod(name={"pub_key"})
    public synchronized IRubyObject get_pub_key() {
        DSAPublicKey key = this.publicKey;
        if (key != null) {
            return this.toBN(key.getY());
        }
        return this.toBN(this.dsa_y);
    }

    @JRubyMethod(name={"pub_key="})
    public synchronized IRubyObject set_pub_key(IRubyObject pub_key2) {
        return this.setKeySpecComponent(1, pub_key2);
    }

    private IRubyObject setKeySpecComponent(int index, IRubyObject value2) {
        KeySpec spec;
        BigInteger val = BN.getBigInteger(value2);
        switch (index) {
            case 0: {
                this.dsa_x = val;
                break;
            }
            case 1: {
                this.dsa_y = val;
                break;
            }
            case 2: {
                this.dsa_p = val;
                break;
            }
            case 3: {
                this.dsa_q = val;
                break;
            }
            case 4: {
                this.dsa_g = val;
            }
        }
        BigInteger _dsa_p = this.getP();
        BigInteger _dsa_q = this.getQ();
        BigInteger _dsa_g = this.getG();
        if (this.dsa_x != null && _dsa_p != null && _dsa_q != null && _dsa_g != null) {
            spec = new DSAPrivateKeySpec(this.dsa_x, _dsa_p, _dsa_q, _dsa_g);
            try {
                this.privateKey = (DSAPrivateKey)SecurityHelper.getKeyFactory("DSA").generatePrivate(spec);
            }
            catch (InvalidKeySpecException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "invalid keyspec", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "unsupported key algorithm (DSA)", e);
            }
            this.dsa_g = null;
            this.dsa_q = null;
            this.dsa_p = null;
            this.dsa_x = null;
        }
        if (this.dsa_y != null && _dsa_p != null && _dsa_q != null && _dsa_g != null) {
            spec = new DSAPublicKeySpec(this.dsa_y, _dsa_p, _dsa_q, _dsa_g);
            try {
                this.publicKey = (DSAPublicKey)SecurityHelper.getKeyFactory("DSA").generatePublic(spec);
            }
            catch (InvalidKeySpecException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "invalid keyspec", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw PKeyDSA.newDSAError(this.getRuntime(), "unsupported key algorithm (DSA)", e);
            }
            this.dsa_g = null;
            this.dsa_q = null;
            this.dsa_p = null;
            this.dsa_y = null;
        }
        return value2;
    }

    public static RaiseException newDSAError(Ruby runtime, String message) {
        return Utils.newError(runtime, PKeyDSA._PKey(runtime).getClass("DSAError"), message);
    }

    static RaiseException newDSAError(Ruby runtime, String message, Exception cause) {
        return Utils.newError(runtime, PKeyDSA._PKey(runtime).getClass("DSAError"), message, cause);
    }
}

