/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.threadlocal.ThreadLocalObject;

@NodeChild(value="value", type=RubyNode.class)
public abstract class RubiniusLastStringWriteNode
extends RubyNode {
    @CompilerDirectives.TruffleBoundary
    @Specialization
    public Object lastStringWrite(Object value) {
        Frame callerFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_WRITE, true);
        FrameSlot slot = callerFrame.getFrameDescriptor().findFrameSlot("$_");
        while (slot == null && (callerFrame = RubyArguments.getDeclarationFrame(callerFrame)) != null) {
            slot = callerFrame.getFrameDescriptor().findFrameSlot("$_");
        }
        if (slot == null) {
            return value;
        }
        try {
            Object currentValue = callerFrame.getObject(slot);
            if (currentValue instanceof ThreadLocalObject) {
                ThreadLocalObject threadLocalObject = (ThreadLocalObject)currentValue;
                threadLocalObject.set(value);
            } else {
                callerFrame.setObject(slot, value);
            }
        }
        catch (FrameSlotTypeException e) {
            throw new UnsupportedOperationException(e);
        }
        return value;
    }

    protected abstract RubyNode getValue();
}

