/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.parser.ArgumentDescriptor;

public class SharedMethodInfo {
    private final SourceSection sourceSection;
    private final LexicalScope lexicalScope;
    private final Arity arity;
    private final DynamicObject definitionModule;
    private final String name;
    private final String notes;
    private final ArgumentDescriptor[] argumentDescriptors;
    private final boolean alwaysClone;
    private final boolean alwaysInline;
    private final boolean needsCallerFrame;

    public SharedMethodInfo(SourceSection sourceSection, LexicalScope lexicalScope, Arity arity, DynamicObject definitionModule, String name, String notes, ArgumentDescriptor[] argumentDescriptors, boolean alwaysClone, boolean alwaysInline, boolean needsCallerFrame) {
        if (argumentDescriptors == null) {
            argumentDescriptors = new ArgumentDescriptor[]{};
        }
        assert (lexicalScope != null);
        this.sourceSection = sourceSection;
        this.lexicalScope = lexicalScope;
        this.arity = arity;
        this.definitionModule = definitionModule;
        this.name = name;
        this.notes = notes;
        this.argumentDescriptors = argumentDescriptors;
        this.alwaysClone = alwaysClone;
        this.alwaysInline = alwaysInline;
        this.needsCallerFrame = needsCallerFrame;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }

    public Arity getArity() {
        return this.arity;
    }

    public String getName() {
        return this.name;
    }

    public String getNotes() {
        return this.notes;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argumentDescriptors;
    }

    public boolean shouldAlwaysClone() {
        return this.alwaysClone;
    }

    public boolean shouldAlwaysInline() {
        return this.alwaysInline;
    }

    public boolean needsCallerFrame() {
        return this.needsCallerFrame;
    }

    public SharedMethodInfo withName(String newName) {
        return new SharedMethodInfo(this.sourceSection, this.lexicalScope, this.arity, this.definitionModule, newName, this.notes, this.argumentDescriptors, this.alwaysClone, this.alwaysInline, this.needsCallerFrame);
    }

    public String getDescriptiveName() {
        StringBuilder descriptiveName = new StringBuilder();
        if (this.definitionModule != null) {
            descriptiveName.append(Layouts.MODULE.getFields(this.definitionModule).getName());
        }
        if (this.name != null) {
            descriptiveName.append('#');
            descriptiveName.append(this.name);
        }
        if (this.notes != null) {
            boolean parens;
            boolean bl = parens = descriptiveName.length() > 0;
            if (parens) {
                descriptiveName.append(" (");
            }
            descriptiveName.append(this.notes);
            if (parens) {
                descriptiveName.append(')');
            }
        }
        return descriptiveName.toString();
    }

    public String getDescriptiveNameAndSource() {
        if (this.sourceSection == null || !this.sourceSection.isAvailable()) {
            return this.getDescriptiveName();
        }
        return this.getDescriptiveName() + " " + RubyLanguage.fileLine(this.sourceSection);
    }
}

