/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.options.OptionDescription;
import org.jruby.truffle.options.OptionTypeException;

public class ByteStringOptionDescription
extends OptionDescription {
    private final byte[] defaultValue;

    public ByteStringOptionDescription(String name, String description, byte[] defaultValue) {
        super(name, description);
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object checkValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return ((String)value).getBytes(Charset.defaultCharset());
        }
        if (value instanceof byte[]) {
            return value;
        }
        throw new OptionTypeException(this.getName(), value.toString());
    }

    @Override
    public String toString(Object value) {
        return new String((byte[])value, StandardCharsets.US_ASCII);
    }
}

