/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCastNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCoreMethodNode;

@GeneratedBy(value=BigDecimalCastNode.class)
public final class BigDecimalCastNodeGen
extends BigDecimalCastNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @Node.Child
    private RubyNode roundingMode_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private BigDecimalCastNodeGen(RubyNode value, RubyNode roundingMode) {
        this.value_ = value;
        this.roundingMode_ = roundingMode;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeObject(VirtualFrame frameValue, Object valueValue, RoundingMode roundingModeValue) {
        return this.specialization_.execute1(frameValue, valueValue, roundingModeValue);
    }

    @Override
    public BigDecimal executeBigDecimal(VirtualFrame frameValue, Object valueValue, RoundingMode roundingModeValue) {
        return this.specialization_.executeBigDecimal(frameValue, valueValue, roundingModeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static BigDecimalCastNode create(RubyNode value, RubyNode roundingMode) {
        return new BigDecimalCastNodeGen(value, roundingMode);
    }

    @GeneratedBy(methodName="doBigDecimalFallback(Object, Object)", value=BigDecimalCastNode.class)
    private static final class FallbackNode_
    extends BaseNode_ {
        FallbackNode_(BigDecimalCastNodeGen root) {
            super(root, 0x7FFFFFFE);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean guardFallback(Object valueValue, Object roundingModeValue) {
            return this.createNext((Frame)null, valueValue, roundingModeValue) == null;
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            if (this.guardFallback(valueValue, roundingModeValue)) {
                return this.root.doBigDecimalFallback(valueValue, roundingModeValue);
            }
            return this.getNext().execute_(frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root) {
            return new FallbackNode_(root);
        }
    }

    @GeneratedBy(methodName="doOther(VirtualFrame, DynamicObject, Object, SnippetNode, CallDispatchHeadNode, CallDispatchHeadNode, CallDispatchHeadNode)", value=BigDecimalCastNode.class)
    private static final class OtherNode_
    extends BaseNode_ {
        @Node.Child
        private SnippetNode isRationalSnippet;
        @Node.Child
        private CallDispatchHeadNode numeratorCallNode;
        @Node.Child
        private CallDispatchHeadNode denominatorCallNode;
        @Node.Child
        private CallDispatchHeadNode toFCallNode;

        OtherNode_(BigDecimalCastNodeGen root, SnippetNode isRationalSnippet, CallDispatchHeadNode numeratorCallNode, CallDispatchHeadNode denominatorCallNode, CallDispatchHeadNode toFCallNode) {
            super(root, 5);
            this.isRationalSnippet = isRationalSnippet;
            this.numeratorCallNode = numeratorCallNode;
            this.denominatorCallNode = denominatorCallNode;
            this.toFCallNode = toFCallNode;
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && !RubyGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue) && !RubyGuards.isRubyBigDecimal(valueValue_)) {
                return this.root.doOther(frameValue, valueValue_, roundingModeValue, this.isRationalSnippet, this.numeratorCallNode, this.denominatorCallNode, this.toFCallNode);
            }
            return this.getNext().execute_(frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root, SnippetNode isRationalSnippet, CallDispatchHeadNode numeratorCallNode, CallDispatchHeadNode denominatorCallNode, CallDispatchHeadNode toFCallNode) {
            return new OtherNode_(root, isRationalSnippet, numeratorCallNode, denominatorCallNode, toFCallNode);
        }
    }

    @GeneratedBy(methodName="doBigDecimal(DynamicObject, Object)", value=BigDecimalCastNode.class)
    private static final class BigDecimalNode_
    extends BaseNode_ {
        BigDecimalNode_(BigDecimalCastNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && BigDecimalCoreMethodNode.isNormalRubyBigDecimal(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.doBigDecimal(valueValue_, roundingModeValue);
            }
            return this.getNext().execute_(frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root) {
            return new BigDecimalNode_(root);
        }
    }

    @GeneratedBy(methodName="doBignum(DynamicObject, Object)", value=BigDecimalCastNode.class)
    private static final class BignumNode_
    extends BaseNode_ {
        BignumNode_(BigDecimalCastNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.doBignum(valueValue_, roundingModeValue);
            }
            return this.getNext().execute_(frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root) {
            return new BignumNode_(root);
        }
    }

    @GeneratedBy(methodName="doDouble(double, Object)", value=BigDecimalCastNode.class)
    private static final class DoubleNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        DoubleNode_(BigDecimalCastNodeGen root, Object valueValue) {
            super(root, 2);
            this.valueImplicitType = RubyTypesGen.getImplicitDoubleClass(valueValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((DoubleNode_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            double valueValue_;
            try {
                if (this.valueImplicitType == Double.TYPE) {
                    valueValue_ = this.root.value_.executeDouble(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_(frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitDouble(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object roundingModeValue = this.root.roundingMode_.execute(frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), roundingModeValue);
            }
            Object roundingModeValue_ = this.root.roundingMode_.execute(frameValue);
            return this.root.doDouble(valueValue_, roundingModeValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            if (RubyTypesGen.isImplicitDouble(valueValue, this.valueImplicitType)) {
                double valueValue_ = RubyTypesGen.asImplicitDouble(valueValue, this.valueImplicitType);
                return this.root.doDouble(valueValue_, roundingModeValue);
            }
            return this.getNext().execute_(frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root, Object valueValue) {
            return new DoubleNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="doInt(long, Object)", value=BigDecimalCastNode.class)
    private static final class IntNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        IntNode_(BigDecimalCastNodeGen root, Object valueValue) {
            super(root, 1);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((IntNode_)other).valueImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            long valueValue_;
            try {
                if (this.valueImplicitType == Long.TYPE) {
                    valueValue_ = this.root.value_.executeLong(frameValue);
                } else if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = RubyTypes.promoteToLong(this.root.value_.executeInteger(frameValue));
                } else {
                    Object valueValue__ = this.executeValue_(frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitLong(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object roundingModeValue = this.root.roundingMode_.execute(frameValue);
                return this.getNext().execute_(frameValue, ex.getResult(), roundingModeValue);
            }
            Object roundingModeValue_ = this.root.roundingMode_.execute(frameValue);
            return this.root.doInt(valueValue_, roundingModeValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                return this.root.doInt(valueValue_, roundingModeValue);
            }
            return this.getNext().execute_(frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root, Object valueValue) {
            return new IntNode_(root, valueValue);
        }
    }

    @GeneratedBy(value=BigDecimalCastNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(BigDecimalCastNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue, Object roundingModeValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue, roundingModeValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            return this.getNext().execute_(frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=BigDecimalCastNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(BigDecimalCastNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue, Object roundingModeValue) {
            return this.uninitialized((Frame)frameValue, valueValue, roundingModeValue);
        }

        static BaseNode_ create(BigDecimalCastNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=BigDecimalCastNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected BigDecimalCastNodeGen root;

        BaseNode_(BigDecimalCastNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (BigDecimalCastNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_, this.root.roundingMode_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object valueValue, Object roundingModeValue) {
            return this.execute_((VirtualFrame)frameValue, valueValue, roundingModeValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

        public Object execute1(VirtualFrame frameValue, Object valueValue, RoundingMode roundingModeValue) {
            return this.execute_(frameValue, valueValue, (Object)roundingModeValue);
        }

        public BigDecimal executeBigDecimal(VirtualFrame frameValue, Object valueValue, RoundingMode roundingModeValue) {
            return (BigDecimal)this.execute1(frameValue, valueValue, roundingModeValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_(frameValue);
            Object roundingModeValue_ = this.root.roundingMode_.execute(frameValue);
            return this.execute_(frameValue, valueValue_, roundingModeValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object valueValue, Object roundingModeValue) {
            if (RubyTypesGen.isImplicitLong(valueValue)) {
                return IntNode_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitDouble(valueValue)) {
                return DoubleNode_.create(this.root, valueValue);
            }
            if (valueValue instanceof DynamicObject) {
                DynamicObject valueValue_ = (DynamicObject)valueValue;
                if (RubyGuards.isRubyBignum(valueValue_)) {
                    return BignumNode_.create(this.root);
                }
                if (BigDecimalCoreMethodNode.isNormalRubyBigDecimal(valueValue_)) {
                    return BigDecimalNode_.create(this.root);
                }
                if (!RubyGuards.isRubyBignum(valueValue_) && !RubyGuards.isRubyBigDecimal(valueValue_)) {
                    SnippetNode isRationalSnippet5 = new SnippetNode();
                    CallDispatchHeadNode numeratorCallNode5 = CallDispatchHeadNode.createMethodCall();
                    CallDispatchHeadNode denominatorCallNode5 = CallDispatchHeadNode.createMethodCall();
                    CallDispatchHeadNode toFCallNode5 = CallDispatchHeadNode.createMethodCall();
                    return OtherNode_.create(this.root, isRationalSnippet5, numeratorCallNode5, denominatorCallNode5, toFCallNode5);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createFallback() {
            return FallbackNode_.create(this.root);
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Double.TYPE) {
                return this.root.value_.executeDouble((VirtualFrame)frameValue);
            }
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }
    }
}

