/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.BindingTrace;

public class PlatformTypesMappedToKotlinChecker {
    public static void checkPlatformTypesMappedToKotlin(@NotNull PlatformToKotlinClassMap platformToKotlinMap, @NotNull BindingTrace trace, @NotNull KtImportDirective importDirective, @NotNull Collection<? extends DeclarationDescriptor> descriptors) {
        if (platformToKotlinMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinMap", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        KtExpression importedReference = importDirective.getImportedReference();
        if (importedReference != null) {
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                PlatformTypesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(platformToKotlinMap, trace, importedReference, declarationDescriptor);
            }
        }
    }

    public static void reportPlatformClassMappedToKotlin(@NotNull PlatformToKotlinClassMap platformToKotlinMap, @NotNull BindingTrace trace, @NotNull KtElement element, @NotNull DeclarationDescriptor descriptor2) {
        if (platformToKotlinMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinMap", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        Collection<ClassDescriptor> kotlinAnalogsForClass = platformToKotlinMap.mapPlatformClass((ClassDescriptor)descriptor2);
        if (!kotlinAnalogsForClass.isEmpty()) {
            trace.report(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.on(element, kotlinAnalogsForClass));
        }
    }
}

