/****************************************************************************
**
*W  gap.h                       GAP source                   Martin Schönert
**
**
*Y  Copyright (C)  1996,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
*Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
*Y  Copyright (C) 2002 The GAP Group
**
**  This file declares the various read-eval-print loops and  related  stuff.
*/

#ifndef libGAP_GAP_GAP_H
#define libGAP_GAP_GAP_H


/****************************************************************************
**

*V  Last  . . . . . . . . . . . . . . . . . . . . . . global variable  'last'
**
**  'Last',  'Last2', and 'Last3'  are the  global variables 'last', 'last2',
**  and  'last3', which are automatically  assigned  the result values in the
**  main read-eval-print loop.
*/
extern libGAP_UInt libGAP_Last;


/****************************************************************************
**
*V  Last2 . . . . . . . . . . . . . . . . . . . . . . global variable 'last2'
*/
extern libGAP_UInt libGAP_Last2;


/****************************************************************************
**
*V  Last3 . . . . . . . . . . . . . . . . . . . . . . global variable 'last3'
*/
extern libGAP_UInt libGAP_Last3;


/****************************************************************************
**
*V  Time  . . . . . . . . . . . . . . . . . . . . . . global variable  'time'
**
**  'Time' is the global variable 'time', which is automatically assigned the
**  time the last command took.
*/
extern libGAP_UInt libGAP_Time;

/****************************************************************************
**
*V  AlarmJumpBuffer . . . . . .long jump buffer used for timeouts 
**
**  Needs to be visible to code in read.c that stores away execution state 
*/


extern libGAP_syJmp_buf libGAP_AlarmJumpBuffers[];
extern libGAP_UInt libGAP_NumAlarmJumpBuffers;


/****************************************************************************
**

*F  ViewObjHandler  . . . . . . . . . handler to view object and catch errors
*/
extern libGAP_UInt libGAP_ViewObjGVar;
extern libGAP_UInt libGAP_CustomViewGVar;

extern void libGAP_ViewObjHandler ( libGAP_Obj obj );


/****************************************************************************
**

*F * * * * * * * * * * * * * * print and error  * * * * * * * * * * * * * * *
*/


/****************************************************************************
**
*F  FuncPrint( <self>, <args> ) . . . . . . . . . . . . . . . .  print <args>
*/
extern libGAP_Obj libGAP_FuncPrint (
    libGAP_Obj                 self,
    libGAP_Obj                 args );


/****************************************************************************
**
*F  ErrorQuit( <msg>, <arg1>, <arg2> )  . . . . . . . . . . .  print and quit
*/
extern void libGAP_ErrorQuit (
            const libGAP_Char *        msg,
            libGAP_Int                 arg1,
            libGAP_Int                 arg2 );

/****************************************************************************
**
*F  ErrorMayQuit( <msg>, <arg1>, <arg2> )  . print, enter break loop and quit
**                                           no option to return anything.
*/
extern void libGAP_ErrorMayQuit (
            const libGAP_Char *        msg,
            libGAP_Int                 arg1,
            libGAP_Int                 arg2 );


/****************************************************************************
**
*F  ErrorQuitBound( <name> )  . . . . . . . . . . . . . . .  unbound variable
*/
extern void libGAP_ErrorQuitBound (
    const libGAP_Char *        name );


/****************************************************************************
**
*F  ErrorQuitFuncResult() . . . . . . . . . . . . . . . . must return a value
*/
extern void libGAP_ErrorQuitFuncResult ( void );


/****************************************************************************
**
*F  ErrorQuitIntSmall( <obj> )  . . . . . . . . . . . . . not a small integer
*/
extern void libGAP_ErrorQuitIntSmall (
    libGAP_Obj                 obj );


/****************************************************************************
**
*F  ErrorQuitIntSmallPos( <obj> ) . . . . . . .  not a positive small integer
*/
extern void libGAP_ErrorQuitIntSmallPos (
    libGAP_Obj                 obj );

/****************************************************************************
**
*F  ErrorQuitIntPos( <obj> ) . . . . . . .  not a positive  integer
*/
extern void libGAP_ErrorQuitIntPos (
    libGAP_Obj                 obj );


/****************************************************************************
**
*F  ErrorQuitBool( <obj> )  . . . . . . . . . . . . . . . . . . not a boolean
*/
extern void libGAP_ErrorQuitBool (
    libGAP_Obj                 obj );


/****************************************************************************
**
*F  ErrorQuitFunc( <obj> )  . . . . . . . . . . . . . . . . .  not a function
*/
extern void libGAP_ErrorQuitFunc (
    libGAP_Obj                 obj );


/****************************************************************************
**
*F  ErrorQuitNrArgs( <narg>, <args> ) . . . . . . . wrong number of arguments
*/
extern void libGAP_ErrorQuitNrArgs (
    libGAP_Int                 narg,
    libGAP_Obj                 args );

/****************************************************************************
**
*F  ErrorQuitRange3( <first>, <second>, <last> ) . . .divisibility rules
*/
extern void libGAP_ErrorQuitRange3 (
    libGAP_Obj                 first,
    libGAP_Obj                 second,
    libGAP_Obj                 last);


/****************************************************************************
**
*F  ErrorReturnObj( <msg>, <arg1>, <arg2>, <msg2> ) . .  print and return obj
*/
extern libGAP_Obj libGAP_ErrorReturnObj (
            const libGAP_Char *        msg,
            libGAP_Int                 arg1,
            libGAP_Int                 arg2,
            const libGAP_Char *        msg2 );


/****************************************************************************
**
*F  ErrorReturnVoid( <msg>, <arg1>, <arg2>, <msg2> )  . . .  print and return
*/
extern void libGAP_ErrorReturnVoid (
            const libGAP_Char *        msg,
            libGAP_Int                 arg1,
            libGAP_Int                 arg2,
            const libGAP_Char *        msg2 );

extern libGAP_Obj libGAP_ErrorLVars;
extern libGAP_Obj libGAP_ErrorLVars0;


/****************************************************************************
**
*T  ExecStatus . . . .  type of status values returned by read, eval and exec
**                      subroutines, explaining why evaluation, or execution
**                      has terminated.
**
**  Values are powers of two, although I do not currently know of any
**  cirumstances where they can get combined
**
** STATUS_END           0    ran off the end of the code 
** STATUS_RETURN_VAL    1    value returned  
** STATUS_RETURN_VOID   2    void returned   
** STATUS_TNM           4    try-next-method 
** STATUS_QUIT          8    quit command
** STATUS_EOF          16    End of file 
** STATUS_ERROR        32    error
** STATUS_QQUIT        64    QUIT command
*/

typedef libGAP_UInt libGAP_ExecStatus;

#define libGAP_STATUS_END         0
#define libGAP_STATUS_RETURN_VAL  1
#define libGAP_STATUS_RETURN_VOID 2
#define libGAP_STATUS_TNM         4
#define libGAP_STATUS_QUIT        8
#define libGAP_STATUS_EOF        16
#define libGAP_STATUS_ERROR      32
#define libGAP_STATUS_QQUIT      64



extern libGAP_UInt libGAP_UserHasQuit;
extern libGAP_UInt libGAP_UserHasQUIT;
extern libGAP_UInt libGAP_SystemErrorCode;

#if 0
/****************************************************************************
**
*F  FuncError( <self>, <args> ) . . . . . . . . . . . . . . . signal an error
**
*/
extern libGAP_Obj libGAP_FuncError (
    libGAP_Obj                 self,
    libGAP_Obj                 args );

#endif


/****************************************************************************
**

*F * * * * * * * * * * * * * important filters  * * * * * * * * * * * * * * *
*/

/****************************************************************************
**

*V  FN_IS_MUTABLE . . . . . . . . . . . . . . . filter number for `IsMutable'
*/
#define libGAP_FN_IS_MUTABLE           1


/****************************************************************************
**
*V  FN_IS_EMPTY . . . . . . . . . . . . . . . . . filter number for `IsEmpty'
*/
#define libGAP_FN_IS_EMPTY             2


/****************************************************************************
**
*V  FN_IS_SSORT . . . . . . . . . . . . . . filter number for `IsSSortedList'
*/
#define libGAP_FN_IS_SSORT             3


/****************************************************************************
**
*V  FN_IS_NSORT . . . . . . . . . . . . . . filter number for `IsNSortedList'
*/
#define libGAP_FN_IS_NSORT             4


/****************************************************************************
**
*V  FN_IS_DENSE . . . . . . . . . . . . . . . filter number for `IsDenseList'
*/
#define libGAP_FN_IS_DENSE             5


/****************************************************************************
**
*V  FN_IS_NDENSE  . . . . . . . . . . . . .  filter number for `IsNDenseList'
*/
#define libGAP_FN_IS_NDENSE            6


/****************************************************************************
**
*V  FN_IS_HOMOG . . . . . . . . . . . . filter number for `IsHomogeneousList'
*/
#define libGAP_FN_IS_HOMOG             7


/****************************************************************************
**
*V  FN_IS_NHOMOG  . . . . . . . . .  filter number for `IsNonHomogeneousList'
*/
#define libGAP_FN_IS_NHOMOG            8


/****************************************************************************
**
*V  FN_IS_TABLE . . . . . . . . . . . . . . . . . filter number for `IsTable'
*/
#define libGAP_FN_IS_TABLE             9

/****************************************************************************
**
*V  FN_IS_RECT . . . . . . . . . . . . filter number for `IsRectangularTable'
*/
#define libGAP_FN_IS_RECT             10
#define libGAP_LAST_FN                 libGAP_FN_IS_RECT


/****************************************************************************
**

*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**

*F  FillInVersion( <module>, <rev_c>, <rev_h> ) . . .  fill in version number
*/
extern void libGAP_FillInVersion (
    libGAP_StructInitInfo *            libGAP_module );


/****************************************************************************
**
*F  RequireModule( <calling>, <required>, <version> ) . . . .  require module
*/
extern void libGAP_RequireModule (
    libGAP_StructInitInfo *            libGAP_module,
    const libGAP_Char *                required,
    libGAP_UInt                        version );


/****************************************************************************
**
*F  InitBagNamesFromTable( <table> )  . . . . . . . . .  initialise bag names
*/
extern void libGAP_InitBagNamesFromTable (
    libGAP_StructBagNames *            tab );


/****************************************************************************
**
*F  InitClearFiltsTNumsFromTable( <tab> ) . . .  initialise clear filts tnums
*/
extern void libGAP_InitClearFiltsTNumsFromTable (
    libGAP_Int *               tab );


/****************************************************************************
**
*F  InitHasFiltListTNumsFromTable( <tab> )  . . initialise tester filts tnums
*/
extern void libGAP_InitHasFiltListTNumsFromTable (
    libGAP_Int *               tab );


/****************************************************************************
**
*F  InitSetFiltListTNumsFromTable( <tab> )  . . initialise setter filts tnums
*/
extern void libGAP_InitSetFiltListTNumsFromTable (
    libGAP_Int *               tab );


/****************************************************************************
**
*F  InitResetFiltListTNumsFromTable( <tab> )  initialise unsetter filts tnums
*/
extern void libGAP_InitResetFiltListTNumsFromTable (
    libGAP_Int *               tab );


/****************************************************************************
**
*F  InitGVarFiltsFromTable( <tab> ) . . . . . . . . . . . . . . . new filters
*/
extern void libGAP_InitGVarFiltsFromTable (
    libGAP_StructGVarFilt *    tab );


/****************************************************************************
**
*F  InitGVarAttrsFromTable( <tab> ) . . . . . . . . . . . . .  new attributes
*/
extern void libGAP_InitGVarAttrsFromTable (
    libGAP_StructGVarAttr *    tab );


/****************************************************************************
**
*F  InitGVarPropsFromTable( <tab> ) . . . . . . . . . . . . .  new properties
*/
extern void libGAP_InitGVarPropsFromTable (
    libGAP_StructGVarProp *    tab );


/****************************************************************************
**
*F  InitGVarOpersFromTable( <tab> ) . . . . . . . . . . . . .  new operations
*/
extern void libGAP_InitGVarOpersFromTable (
    libGAP_StructGVarOper *    tab );


/****************************************************************************
**
*F  InitGVarFuncsFromTable( <tab> ) . . . . . . . . . . . . . .  new function
*/
extern void libGAP_InitGVarFuncsFromTable (
    libGAP_StructGVarFunc *    tab );


/****************************************************************************
**
*F  InitHdlrFiltsFromTable( <tab> ) . . . . . . . . . . . . . . . new filters
*/
extern void libGAP_InitHdlrFiltsFromTable (
    libGAP_StructGVarFilt *    tab );


/****************************************************************************
**
*F  InitHdlrAttrsFromTable( <tab> ) . . . . . . . . . . . . .  new attributes
*/
extern void libGAP_InitHdlrAttrsFromTable (
    libGAP_StructGVarAttr *    tab );


/****************************************************************************
**
*F  InitHdlrPropsFromTable( <tab> ) . . . . . . . . . . . . .  new properties
*/
extern void libGAP_InitHdlrPropsFromTable (
    libGAP_StructGVarProp *    tab );


/****************************************************************************
**
*F  InitHdlrOpersFromTable( <tab> ) . . . . . . . . . . . . .  new operations
*/
extern void libGAP_InitHdlrOpersFromTable (
    libGAP_StructGVarOper *    tab );


/****************************************************************************
**
*F  InitHdlrFuncsFromTable( <tab> ) . . . . . . . . . . . . . . new functions
*/
extern void libGAP_InitHdlrFuncsFromTable (
    libGAP_StructGVarFunc *    tab );


/****************************************************************************
**
*F  ImportGVarFromLibrary( <name>, <address> )  . . .  import global variable
*/
extern void libGAP_ImportGVarFromLibrary(
            const libGAP_Char *        name,
            libGAP_Obj *               address );


/****************************************************************************
**
*F  ImportFuncFromLibrary( <name>, <address> )  . . .  import global function
*/
extern void libGAP_ImportFuncFromLibrary(
            const libGAP_Char *        name,
            libGAP_Obj *               address );


/****************************************************************************
**

*V  Revisions . . . . . . . . . . . . . . . . . .  record of revision numbers
*/
extern libGAP_Obj libGAP_Revisions;


extern libGAP_Obj libGAP_Error;
extern libGAP_Obj libGAP_ErrorInner;

/****************************************************************************
**

*F  Modules . . . . . . . . . . . . . . . . . . . . . . . . . list of modules
*/
extern libGAP_StructInitInfo * libGAP_Modules [];
extern libGAP_UInt libGAP_NrModules;
extern libGAP_UInt libGAP_NrBuiltinModules;




/****************************************************************************
**
*F  RecordLoadedModule( <module> )  . . . . . . . . store module in <Modules>
**
**  The filename argument is a C string. A copy of it is taken in some
**   private space and added to the module info.
*/
extern void libGAP_RecordLoadedModule (
    libGAP_StructInitInfo *        libGAP_module,
    libGAP_Char *                  filename );




/****************************************************************************
**

*F  InitializeGap( <argc>, <argv> ) . . . . . . . . . . . . . . . .  init GAP
*/
extern void libGAP_InitializeGap (
            int *               pargc,
            char *              argv [] );


#endif // GAP_GAP_H

/****************************************************************************
**

*E  gap.h . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
