/**
 * Copyright (c) 2011-2016 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */

include("../InfoPosition/InfoPosition.js");

/**
 * \class InfoPositionPolRel
 * \ingroup ecma_information
 * \brief Query relative polar position.
 */
function InfoPositionPolRel(guiAction) {
    InfoPosition.call(this, guiAction);
}

InfoPositionPolRel.prototype = new InfoPosition();

InfoPositionPolRel.prototype.getDisplayedLabel = function(p, prec) {
    if (isNull(prec)) {
        prec = 4;
    }

    var di = this.getDocumentInterface();
    var relZero = di.getRelativeZero();
    if (!relZero.isValid()) {
        relZero = new RVector(0,0);
    }
    p = p.operator_subtract(relZero);
    return coordinateToString(p, prec, true, true, this.getDocument());
};
